/*
 * Decompiled with CFR 0.152.
 */
package net.spy.pool;

import net.spy.net.SNPP;
import net.spy.pool.PoolAble;
import net.spy.pool.PoolException;
import net.spy.pool.PoolFiller;
import net.spy.pool.SNPPPoolAble;
import net.spy.util.SpyConfig;

public class SNPPPoolFiller
extends PoolFiller {
    public SNPPPoolFiller(String name, SpyConfig conf) {
        super(name, conf);
    }

    public PoolAble getObject() throws PoolException {
        SNPPPoolAble sp = null;
        try {
            String hostname = null;
            int port = 444;
            hostname = this.getProperty("snppHost");
            if (hostname == null) {
                throw new Exception("No snppHost property given");
            }
            port = this.getPropertyInt("snppPort", 444);
            int timeout = this.getPropertyInt("snppTimeout", 0);
            long maxAge = this.getPropertyInt("max_age", 0);
            SNPP snpp = new SNPP(hostname, port, timeout);
            sp = new SNPPPoolAble(snpp, maxAge, this.getPoolHash());
        }
        catch (Exception e) {
            throw new PoolException("Error getting new SNPP object for the " + this.debugName() + " pool:  " + e);
        }
        return sp;
    }
}

