/*
 * Decompiled with CFR 0.152.
 */
package net.spy.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashSet<T>
extends AbstractSet<T> {
    private transient WeakHashMap<T, Object> map = null;
    private static final Object PRESENT = new Object();

    public WeakHashSet() {
        this.map = new WeakHashMap();
    }

    public WeakHashSet(int n) {
        this.map = new WeakHashMap(n);
    }

    public WeakHashSet(Collection<T> c) {
        this();
        if (c == null) {
            throw new NullPointerException("Null collection provided to WeakHashSet");
        }
        this.addAll(c);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(T o) {
        Object old = this.map.put(o, PRESENT);
        return old == null;
    }

    @Override
    public boolean remove(Object o) {
        Object old = this.map.remove(o);
        return old == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

