/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.expr;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.MethodInfo;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac;
import org.zeroturnaround.bundled.javassist.expr.Expr;

public class MethodCall
extends Expr {
    protected MethodCall(int pos, CodeIterator i, CtClass declaring, MethodInfo m) {
        super(pos, i, declaring, m);
    }

    private int getNameAndType(ConstPool cp) {
        int pos = this.currentPos;
        int c = this.iterator.byteAt(pos);
        int index = this.iterator.u16bitAt(pos + 1);
        if (c == 185) {
            return cp.getInterfaceMethodrefNameAndType(index);
        }
        return cp.getMethodrefNameAndType(index);
    }

    public CtBehavior where() {
        return super.where();
    }

    public int getLineNumber() {
        return super.getLineNumber();
    }

    public String getFileName() {
        return super.getFileName();
    }

    protected CtClass getCtClass() throws NotFoundException {
        return this.thisClass.getClassPool().get(this.getClassName());
    }

    /*
     * WARNING - void declaration
     */
    public String getClassName() {
        void cname;
        ConstPool constPool = this.getConstPool();
        int cp = this.currentPos;
        int pos = this.iterator.byteAt(cp);
        int c = this.iterator.u16bitAt(cp + 1);
        String index = pos == 185 ? constPool.getInterfaceMethodrefClassName(c) : cname.getMethodrefClassName(c);
        if (index.charAt(0) == '[') {
            index = Descriptor.toClassName(index);
        }
        return index;
    }

    public String getMethodName() {
        ConstPool cp = this.getConstPool();
        int nt = this.getNameAndType(cp);
        return cp.getUtf8Info(cp.getNameAndTypeName(nt));
    }

    public CtMethod getMethod() throws NotFoundException {
        return this.getCtClass().getMethod(this.getMethodName(), this.getSignature());
    }

    public String getSignature() {
        ConstPool cp = this.getConstPool();
        int nt = this.getNameAndType(cp);
        return cp.getUtf8Info(cp.getNameAndTypeDescriptor(nt));
    }

    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public boolean isSuper() {
        return this.iterator.byteAt(this.currentPos) == 183 && !this.where().getDeclaringClass().getName().equals(this.getClassName());
    }

    /*
     * WARNING - void declaration
     */
    public void replace(String statement) throws CannotCompileException {
        String signature;
        int methodname;
        void classname;
        String c;
        String opcodeSize;
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int pos = this.currentPos;
        int index = this.iterator.u16bitAt(pos + 1);
        int n = this.iterator.byteAt(pos);
        if (n == 185) {
            int n2 = 5;
            String string = constPool.getInterfaceMethodrefClassName(index);
            opcodeSize = constPool.getInterfaceMethodrefName(index);
            c = constPool.getInterfaceMethodrefType(index);
        } else if (classname == 184 || classname == 183 || classname == 182) {
            methodname = 3;
            signature = constPool.getMethodrefClassName(index);
            opcodeSize = constPool.getMethodrefName(index);
            c = constPool.getMethodrefType(index);
        } else {
            throw new CannotCompileException("not method invocation");
        }
        Javac jc = new Javac(this.thisClass);
        ClassPool cp = this.thisClass.getClassPool();
        CodeAttribute ca = this.iterator.get();
        try {
            CtClass[] params = Descriptor.getParameterTypes(c, cp);
            CtClass retType = Descriptor.getReturnType(c, cp);
            int paramVar = ca.getMaxLocals();
            jc.recordParams(signature, params, true, paramVar, this.withinStatic());
            int retVar = jc.recordReturnType(retType, true);
            if (classname == 184) {
                jc.recordStaticProceed(signature, opcodeSize);
            } else if (classname == 183) {
                jc.recordSpecialProceed("$0", signature, opcodeSize, c);
            } else {
                jc.recordProceed("$0", opcodeSize);
            }
            MethodCall.checkResultValue(retType, statement);
            Bytecode bytecode = jc.getBytecode();
            MethodCall.storeStack(params, classname == 184, paramVar, bytecode);
            jc.recordLocalVariables(ca, pos);
            if (retType != CtClass.voidType) {
                bytecode.addConstZero(retType);
                bytecode.addStore(retVar, retType);
            }
            jc.compileStmnt(statement);
            if (retType != CtClass.voidType) {
                bytecode.addLoad(retVar, retType);
            }
            this.replace0(pos, bytecode, methodname);
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException("broken method");
        }
    }
}

