/*
 * Decompiled with CFR 0.152.
 */
package er.taggable;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXQ;
import er.taggable.ERTaggableEntity;
import er.taggable.model.ERTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERTaggable<T extends ERXGenericRecord> {
    private T _item;
    private ERTaggableEntity<T> _entity;

    protected ERTaggable(ERTaggableEntity<T> entity, T item) {
        this._entity = entity;
        this._item = item;
    }

    public int hashCode() {
        return this._item.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ERTaggable && ((ERTaggable)obj)._item.equals(this._item);
    }

    public static <T extends ERXGenericRecord> ERTaggable<T> taggable(T eo) {
        return ERTaggableEntity.taggableEntity(eo).taggable(eo);
    }

    public T item() {
        return this._item;
    }

    public ERTaggableEntity<T> taggableEntity() {
        return this._entity;
    }

    public NSArray<ERTag> tags() {
        String tagsRelationshipName = this._entity.tagsRelationshipName();
        return (NSArray)this._item.valueForKeyPath(tagsRelationshipName);
    }

    public void clearTags() {
        for (ERTag tag : this.tags().immutableClone()) {
            this.removeTag(tag);
        }
    }

    public void removeTags(Object tags) {
        NSArray<ERTag> erTags = this.tags();
        NSArray matchingTags = ERXQ.filtered(erTags, (EOQualifier)ERTag.NAME.in(this._entity.splitTagNames(tags)));
        for (ERTag tag : matchingTags) {
            this.removeTag(tag);
        }
    }

    public void removeTagNamed(String tagName) {
        NSArray<ERTag> erTags = this.tags();
        NSArray matchingTags = ERXQ.filtered(erTags, (EOQualifier)ERTag.NAME.is((Object)tagName));
        for (ERTag tag : matchingTags) {
            this.removeTag(tag);
        }
    }

    public void addTagNamed(String tagName) {
        this.addTags(false, ERTag.escapeTagNamed(tagName));
    }

    public void addTags(Object tags) {
        this.addTags(false, tags);
    }

    public void addTags(boolean clear, Object tags) {
        if (clear) {
            this.clearTags();
        }
        NSArray<ERTag> erTags = this.tags();
        EOEditingContext editingContext = this._item.editingContext();
        for (String tagName : this._entity.splitTagNames(tags)) {
            ERTag tag = this._entity.fetchTagNamed(editingContext, tagName, true);
            if (erTags.containsObject((Object)tag)) continue;
            this.addTag(tag);
        }
    }

    protected void addTag(ERTag tag) {
        this._item.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)tag, this._entity.tagsRelationshipName());
    }

    protected void removeTag(ERTag tag) {
        this._item.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)tag, this._entity.tagsRelationshipName());
    }

    public void setTags(Object tags) {
        this.addTags(true, tags);
    }

    public NSArray<String> tagNames() {
        return (NSArray)this.tags().valueForKey("name");
    }

    public boolean isTaggedWith(String tagName) {
        return ERXQ.filtered(this.tags(), (EOQualifier)ERTag.NAME.is((Object)tagName)).count() > 0;
    }

    public boolean isTaggedWithAll(Object tags) {
        NSArray<String> tagNames = this._entity.splitTagNames(tags);
        return ERXQ.filtered(this.tags(), (EOQualifier)ERTag.NAME.in(tagNames)).count() == tagNames.count();
    }

    public boolean isTaggedWithAny(Object tags) {
        NSArray<String> tagNames = this._entity.splitTagNames(tags);
        return ERXQ.filtered(this.tags(), (EOQualifier)ERTag.NAME.in(tagNames)).count() > 0;
    }
}

