/*
 * Decompiled with CFR 0.152.
 */
package er.memoryadaptor;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRange;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import ognl.Ognl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EREntityStore {
    private int _sequence = 0;

    public void clear() {
        this._sequence = 0;
    }

    public void commitFromTransactionStore(EREntityStore store) {
        throw new UnsupportedOperationException("Transactions are not supported in " + this.getClass().getName());
    }

    public int deleteRowsDescribedByQualifier(EOQualifier qualifier, EOEntity entity) {
        try {
            int count = 0;
            Iterator<NSMutableDictionary<String, Object>> i = this.iterator();
            while (i.hasNext()) {
                NSMutableDictionary<String, Object> rawRow = i.next();
                NSMutableDictionary<String, Object> row = this.rowFromStoredValues(rawRow, entity);
                if (qualifier != null && !qualifier.evaluateWithObject(row)) continue;
                i.remove();
                ++count;
            }
            return count;
        }
        catch (EOGeneralAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to delete '" + entity.name() + "' with qualifier " + qualifier + ": " + e.getMessage());
        }
    }

    public NSMutableArray<NSMutableDictionary<String, Object>> fetch(NSArray<EOAttribute> attributesToFetch, EOFetchSpecification fetchSpecification, boolean shouldLock, EOEntity entity) {
        Object qualifier = null;
        int fetchLimit = 0;
        NSArray sortOrderings = null;
        if (fetchSpecification != null) {
            qualifier = fetchSpecification.qualifier();
            fetchLimit = fetchSpecification.fetchLimit();
            sortOrderings = fetchSpecification.sortOrderings();
        }
        if (entity.restrictingQualifier() != null) {
            qualifier = qualifier != null ? new EOAndQualifier(new NSArray((Object[])new EOQualifier[]{qualifier, entity.restrictingQualifier()})) : entity.restrictingQualifier();
        }
        NSMutableArray fetchedRows = new NSMutableArray();
        Iterator<NSMutableDictionary<String, Object>> i = this.iterator();
        while (i.hasNext()) {
            NSMutableDictionary<String, Object> rawRow = i.next();
            NSMutableDictionary<String, Object> row = this.rowFromStoredValues(rawRow, entity);
            if (qualifier != null && !qualifier.evaluateWithObject(row)) continue;
            fetchedRows.addObject(row);
        }
        if (sortOrderings != null) {
            EOSortOrdering.sortArrayUsingKeyOrderArray((NSMutableArray)fetchedRows, (NSArray)sortOrderings);
        }
        if (fetchLimit > 0 && fetchedRows.count() > fetchLimit) {
            fetchedRows.removeObjectsInRange(new NSRange(fetchLimit, fetchedRows.count() - fetchLimit));
        }
        return fetchedRows;
    }

    protected NSMutableDictionary<String, Object> rowFromStoredValues(NSMutableDictionary<String, Object> rawRow, EOEntity entity) {
        NSMutableDictionary row = new NSMutableDictionary(rawRow.count());
        for (EOAttribute attribute : entity.attributesToFetch()) {
            Object value = rawRow.objectForKey((Object)attribute.columnName());
            if (attribute.isDerived()) {
                if (!attribute.isFlattened()) {
                    String expression = attribute.definition().replaceAll("\\|\\|", "+ '' +");
                    try {
                        value = Ognl.getValue((String)expression, rawRow);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else {
                    String dstKey = attribute.definition();
                    value = rawRow.objectForKey((Object)dstKey);
                }
            }
            row.setObjectForKey(value != null ? value : NSKeyValueCoding.NullValue, (Object)attribute.name());
        }
        return row;
    }

    protected abstract void _insertRow(NSMutableDictionary<String, Object> var1, EOEntity var2);

    public void insertRow(NSDictionary<String, Object> row, EOEntity entity) {
        try {
            NSMutableDictionary mutableRow = new NSMutableDictionary(row.size());
            Enumeration e = entity.attributes().objectEnumerator();
            while (e.hasMoreElements()) {
                EOAttribute attribute = (EOAttribute)e.nextElement();
                Object value = row.objectForKey((Object)attribute.name());
                if (attribute.isDerived()) continue;
                mutableRow.setObjectForKey(value != null ? value : NSKeyValueCoding.NullValue, (Object)attribute.columnName());
            }
            this._insertRow((NSMutableDictionary<String, Object>)mutableRow, entity);
        }
        catch (EOGeneralAdaptorException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to insert '" + entity.name() + "' with row " + row + ": " + e.getMessage());
        }
    }

    public abstract Iterator<NSMutableDictionary<String, Object>> iterator();

    public int nextSequence() {
        return ++this._sequence;
    }

    public EREntityStore transactionStore() {
        throw new UnsupportedOperationException("Transactions are not supported in " + this.getClass().getName());
    }

    public int updateValuesInRowsDescribedByQualifier(NSDictionary<String, Object> updatedRow, EOQualifier qualifier, EOEntity entity) {
        try {
            int count = 0;
            Iterator<NSMutableDictionary<String, Object>> i = this.iterator();
            while (i.hasNext()) {
                NSMutableDictionary<String, Object> rawRow = i.next();
                NSMutableDictionary<String, Object> row = this.rowFromStoredValues(rawRow, entity);
                if (qualifier != null && !qualifier.evaluateWithObject(row)) continue;
                for (Map.Entry entry : updatedRow.entrySet()) {
                    EOAttribute attribute = entity.attributeNamed((String)entry.getKey());
                    rawRow.setObjectForKey(entry.getValue(), (Object)attribute.columnName());
                }
                ++count;
            }
            return count;
        }
        catch (EOGeneralAdaptorException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new EOGeneralAdaptorException("Failed to update '" + entity.name() + "' row " + updatedRow + " with qualifier " + qualifier + ": " + e.getMessage());
        }
    }

    public static interface JoinEntityStore {
    }
}

