/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueArchiving;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class EODetailDataSource
extends EODataSource
implements Serializable,
EOKeyValueArchiving {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EODetailDataSource");
    private EOClassDescription _masterClassDescription;
    private transient EODataSource _masterDataSource;
    private transient EOEnterpriseObject _masterObject;
    private String _detailKey;
    static final long serialVersionUID = 8608471659754778990L;
    private static final String EntityNameFieldKey = "entityName";
    private static final String DetailKeyFieldKey = "detailKey";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("entityName", _NSUtilities._StringClass), new ObjectStreamField("detailKey", _NSUtilities._StringClass)};

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(EntityNameFieldKey, this._masterClassDescription.entityName());
        fields.put(DetailKeyFieldKey, this._detailKey);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        String entityName = (String)fields.get(EntityNameFieldKey, null);
        String detailKey = (String)fields.get(DetailKeyFieldKey, null);
        if (entityName == null || entityName.length() < 1) {
            throw new StreamCorruptedException("While unarchiving a \"" + this.getClass().getName() + "\" a valid entity name was missing from the stream.");
        }
        this._masterClassDescription = EOClassDescription.classDescriptionForEntityName(entityName);
        this.qualifyWithRelationshipKey(detailKey, null);
    }

    public EODetailDataSource(EOClassDescription masterClassDescription, String key) {
        this._masterClassDescription = masterClassDescription;
        this.qualifyWithRelationshipKey(key, null);
    }

    public EODetailDataSource(EODataSource masterDataSource, String key) {
        this(masterDataSource != null ? masterDataSource.classDescriptionForObjects() : null, key);
        this._masterDataSource = masterDataSource;
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        String entityName = (String)unarchiver.decodeObjectForKey("masterClassDescription");
        String detailKey = (String)unarchiver.decodeObjectForKey(DetailKeyFieldKey);
        EODetailDataSource dataSource = new EODetailDataSource(EOClassDescription.classDescriptionForEntityName(entityName), detailKey);
        dataSource.qualifyWithRelationshipKey(detailKey, null);
        return dataSource;
    }

    public void encodeWithKeyValueArchiver(EOKeyValueArchiver archiver) {
        archiver.encodeObject(this._detailKey, DetailKeyFieldKey);
        archiver.encodeObject(this._masterClassDescription.entityName(), "masterClassDescription");
    }

    public void qualifyWithRelationshipKey(String key, Object sourceObject) {
        this._masterObject = (EOEnterpriseObject)sourceObject;
        this._detailKey = key.equals("self") ? null : key;
    }

    public NSArray fetchObjects() {
        NSArray details = null;
        if (this._masterObject != null) {
            EOEnterpriseObject value;
            EOEnterpriseObject eOEnterpriseObject = value = this._detailKey == null ? this._masterObject : this._masterObject.valueForKeyPath(this._detailKey);
            if (value != null && value != NSKeyValueCoding.NullValue) {
                details = value instanceof NSArray ? new NSArray((NSArray)value) : new NSArray((Object)value);
            }
        }
        if (details == null) {
            details = NSArray.EmptyArray;
        }
        return details;
    }

    public void insertObject(Object eo) {
        if (this._masterObject == null || this._detailKey == null) {
            throw new IllegalStateException("attempt to insert object in DetailDataSource without a masterObject or detailKey");
        }
        this._masterObject.addObjectToBothSidesOfRelationshipWithKey((EOEnterpriseObject)eo, this._detailKey);
    }

    public void deleteObject(Object eo) {
        if (this._masterObject == null || this._detailKey == null) {
            throw new IllegalStateException("attempt to delete object in DetailDataSource without a masterObject or detailKey");
        }
        this._masterObject.removeObjectFromBothSidesOfRelationshipWithKey((EOEnterpriseObject)eo, this._detailKey);
    }

    public EOEditingContext editingContext() {
        if (this._masterDataSource != null) {
            return this._masterDataSource.editingContext();
        }
        if (this._masterObject != null) {
            return this._masterObject.editingContext();
        }
        return null;
    }

    public EOClassDescription classDescriptionForObjects() {
        if (this._masterClassDescription == null && this._masterDataSource != null) {
            this._masterClassDescription = this._masterDataSource.classDescriptionForObjects();
        }
        if (this._masterClassDescription != null && this._detailKey != null) {
            return this._classDescriptionForKeyPath(this._masterClassDescription, this._detailKey);
        }
        return this._masterClassDescription;
    }

    private EOClassDescription _classDescriptionForKeyPath(EOClassDescription target, String keyPath) {
        String key;
        int keyStart = 0;
        int index = keyPath.indexOf(46);
        while (index > 0) {
            key = keyPath.substring(keyStart, index);
            if ((target = target.classDescriptionForDestinationKey(key)) == null) {
                return null;
            }
            keyStart = index + 1;
            index = keyPath.indexOf(46, keyStart);
        }
        key = keyPath.substring(keyStart);
        target = target.classDescriptionForDestinationKey(key);
        return target;
    }

    void setMasterDataSource(EODataSource masterDataSource) {
        this._masterClassDescription = masterDataSource != null ? masterDataSource.classDescriptionForObjects() : null;
        this._masterDataSource = masterDataSource;
    }

    public EODataSource masterDataSource() {
        return this._masterDataSource;
    }

    public void setMasterClassDescription(EOClassDescription master) {
        this._masterClassDescription = master;
    }

    public EOClassDescription masterClassDescription() {
        return this._masterClassDescription;
    }

    public String detailKey() {
        return this._detailKey == null ? "self" : this._detailKey;
    }

    public void setDetailKey(String detailKeyPath) {
        this._detailKey = detailKeyPath;
    }

    public Object masterObject() {
        return this._masterObject;
    }

    public EODataSource dataSourceQualifiedByKey(String key) {
        return new EODetailDataSource(this, key);
    }
}

