/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eocontrol;

import com.webobjects.eocontrol.EOEvent;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;

public class EOEventCenter {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOEventCenter");
    public static final String EventLoggingOverflowDisplay = "EOEventLoggingOverflowDisplay";
    public static final String EventLoggingEnabled = "EOEventLoggingEnabled";
    public static final String EventLoggingLimit = "EOEventLoggingLimit";
    public static final String EventLoggingPassword = "EOEventLoggingPassword";
    private EOEvent _rootEvent;
    private EOEvent _lastEvent;
    private NSMutableArray _events = new NSMutableArray(32);
    private long _eventCounter;
    private static volatile String _password;
    private static final WeakHashMap _centers;
    private static final NSMutableDictionary _classesWithCallbacks;
    private static final NSMutableDictionary _classesWithCallbacksState;
    private static final int capacity = 1024;
    private static final int size = 1024;
    private static volatile Class eventCenterClass;
    private static volatile int sleepy;
    private static boolean _loggingErrorAbort;
    private static boolean defaultLoggingEnabled;
    private static boolean logOverflow;
    private static final NSSelector _resetLoggingCall;
    private static final NSSelector _setLoggingEnabledCall;
    private static long eventLimit;
    private static final String DisabledMarker = "***Disabled***";

    public static void suspendLogging() {
        ++sleepy;
    }

    public static void resumeLogging() {
        if (--sleepy < 0) {
            sleepy = 0;
        }
    }

    public static void setPassword(String p) {
        _password = p;
    }

    public static String password() {
        return _password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOEventCenter currentCenter() {
        EOEventCenter ctr = null;
        Thread thisThread = Thread.currentThread();
        WeakHashMap weakHashMap = _centers;
        synchronized (weakHashMap) {
            ctr = (EOEventCenter)_centers.get(thisThread);
        }
        if (ctr == null) {
            ctr = new EOEventCenter();
            weakHashMap = _centers;
            synchronized (weakHashMap) {
                _centers.put(thisThread, ctr);
            }
        }
        return ctr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray allCenters() {
        Object[] objects;
        WeakHashMap weakHashMap = _centers;
        synchronized (weakHashMap) {
            Collection valueSet = _centers.values();
            objects = valueSet.toArray();
        }
        return new NSArray(objects);
    }

    public static void resetLoggingForAllCenters() {
        NSArray all = EOEventCenter.allCenters();
        all.makeObjectsPerformSelector(_resetLoggingCall, null);
    }

    public void resetLogging() {
        this._events.removeAllObjects();
        this._rootEvent = null;
        this._lastEvent = null;
        this._eventCounter = 0L;
        _loggingErrorAbort = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEventClass(Class aClass, EventRecordingHandler handler) {
        NSMutableDictionary nSMutableDictionary = _classesWithCallbacks;
        synchronized (nSMutableDictionary) {
            if (_classesWithCallbacks.objectForKey((Object)aClass) == null) {
                Object state = defaultLoggingEnabled ? aClass : DisabledMarker;
                _classesWithCallbacks.setObjectForKey((Object)handler, (Object)aClass);
                _classesWithCallbacksState.setObjectForKey(state, (Object)aClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray registeredEventClasses() {
        NSMutableDictionary nSMutableDictionary = _classesWithCallbacks;
        synchronized (nSMutableDictionary) {
            return _classesWithCallbacks.allKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean recordsEventsForClass(Class eventClass) {
        NSMutableDictionary nSMutableDictionary = _classesWithCallbacks;
        synchronized (nSMutableDictionary) {
            Object cp = _classesWithCallbacksState.objectForKey((Object)eventClass);
            if (cp == null) {
                return false;
            }
            return cp != DisabledMarker;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRecordsEvents(boolean flag, Class eventClass) {
        NSMutableDictionary nSMutableDictionary = _classesWithCallbacks;
        synchronized (nSMutableDictionary) {
            Object target = _classesWithCallbacks.objectForKey((Object)eventClass);
            if (target != null) {
                Object[] objects = new Object[]{flag ? Boolean.TRUE : Boolean.FALSE, eventClass};
                Object state = flag ? eventClass : DisabledMarker;
                NSSelector._safeInvokeSelector((NSSelector)_setLoggingEnabledCall, (Object)target, (Object[])objects);
                _classesWithCallbacksState.setObjectForKey(state, (Object)eventClass);
            }
        }
    }

    public static EOEvent newEventOfClass(Class aClass, String type) {
        if (aClass == null || sleepy != 0 || _loggingErrorAbort) {
            return null;
        }
        EOEvent ret = (EOEvent)_NSUtilities.instantiateObject((Class)aClass, null, null, (boolean)true, (boolean)true);
        if (ret != null) {
            ret.setType(type);
        }
        return ret;
    }

    private void _pruneEventTree(EOEvent event) {
        if (event == null) {
            return;
        }
        for (EOEvent next = event; next != null; next = next._nextEvent()) {
            this._pruneEventTree(next._childEvent());
            this._events.removeObject((Object)next);
        }
        this._eventCounter = this._events.count();
    }

    private void _trimDownEventTreeTo(long cutoff) {
        if (this._rootEvent == this._lastEvent) {
            return;
        }
        EOEvent next = this._rootEvent != null ? this._rootEvent._nextEvent() : null;
        if (null == next) {
            return;
        }
        long threshold = cutoff / 5L;
        do {
            EOEvent last;
            EOEvent eOEvent = next = (last = this._rootEvent._nextEvent()) != null ? last._nextEvent() : null;
            if (last == null || next == null || EOEvent.isOpenBranch(last._preciseDuration())) break;
            last._setNextEvent(null);
            this._pruneEventTree(last);
            this._rootEvent._setNextEvent(next);
            if (this._lastEvent != last) continue;
            this._lastEvent = this._rootEvent;
        } while (this._eventCounter >= cutoff - threshold);
        if (this._eventCounter >= cutoff) {
            if (logOverflow) {
                NSLog.err.appendln((Object)("<EOEventCenter> Emergency event logging abort... event stack overflow, could not reduce to " + cutoff + " events. Event logging stopped until event log reset is performed."));
            }
            _loggingErrorAbort = true;
        }
    }

    public void _appendEvent(EOEvent event) {
        if (sleepy != 0) {
            return;
        }
        if (this._eventCounter > eventLimit) {
            this._trimDownEventTreeTo(eventLimit);
            if (logOverflow) {
                NSLog.err.appendln((Object)("<EOEventCenter> Overflowing event stack... shrunk from " + eventLimit + " to " + this._eventCounter + " events"));
            }
        }
        ++this._eventCounter;
        if (event != null && !this._events.containsObject((Object)event)) {
            this._events.addObject((Object)event);
            if (this._lastEvent != null) {
                this._lastEvent._appendEvent(event);
            }
            this._lastEvent = event;
            if (this._rootEvent == null) {
                this._rootEvent = this._lastEvent;
            }
        } else {
            NSLog.err.appendln((Object)("<EOEventCenter> Error inserting event " + event));
        }
    }

    private EOEvent _cancelRootEvent(EOEvent event) {
        if (event == this._rootEvent) {
            this._rootEvent = null;
            this._lastEvent = null;
            return null;
        }
        for (EOEvent next = this._rootEvent; next != null; next = next._nextEvent()) {
            if (next._nextEvent() != event) continue;
            next._setNextEvent(null);
            return next;
        }
        return null;
    }

    private void _cancelEvent(EOEvent event) {
        if (event == null) {
            return;
        }
        EOEvent parent = event.parentEvent();
        if (EOEvent.isClosedBranch(event._preciseDuration()) || EOEvent.isAtomic(event._preciseDuration()) || EOEvent.isClosedBranch(parent != null ? parent._preciseDuration() : 0L)) {
            return;
        }
        EOEvent last = parent == null ? this._cancelRootEvent(event) : parent._cancelEvent(event);
        if (last != null) {
            event._setNextEvent(null);
            this._pruneEventTree(event);
            this._lastEvent = last;
        }
        this._eventCounter = this._events.count();
    }

    public void _markEndOfEvent(EOEvent event) {
        if (event != null) {
            event._markEndWithLastEvent(this._lastEvent);
        }
    }

    public static void markStartOfEvent(EOEvent anEvent, Object info) {
        if (anEvent != null) {
            anEvent.markStartWithInfo(info);
            EOEventCenter.currentCenter()._appendEvent(anEvent);
        }
    }

    public static void markAtomicEvent(EOEvent anEvent, Object info) {
        if (anEvent != null) {
            anEvent.markAtomicWithInfo(info);
            EOEventCenter.currentCenter()._appendEvent(anEvent);
        }
    }

    public static void markEndOfEvent(EOEvent anEvent) {
        if (anEvent != null) {
            EOEventCenter.currentCenter()._markEndOfEvent(anEvent);
        }
    }

    public static void cancelEvent(EOEvent anEvent) {
        if (anEvent != null) {
            EOEventCenter.currentCenter()._cancelEvent(anEvent);
        }
    }

    public NSArray eventsOfClass(Class aClass, String type) {
        NSMutableArray all = new NSMutableArray();
        for (EOEvent next = this._rootEvent; next != null; next = next._nextEvent()) {
            all.addObjectsFromArray(next._nestedEventsOfClass(aClass, type));
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray eventsOfClassForAllCenters(Class aClass, String type) {
        Collection ctrs;
        WeakHashMap weakHashMap = _centers;
        synchronized (weakHashMap) {
            ctrs = _centers.values();
        }
        Iterator iter = ctrs.iterator();
        NSMutableArray allEvents = new NSMutableArray();
        while (iter.hasNext()) {
            EOEventCenter evc = (EOEventCenter)iter.next();
            allEvents.addObjectsFromArray(evc.eventsOfClass(aClass, type));
        }
        return allEvents;
    }

    private void _deepRootLevelEventsFromEvents(NSArray a, NSMutableArray dst) {
        int n = a.count();
        for (int i = 0; i < n; ++i) {
            EOEvent e = (EOEvent)a.objectAtIndex(i);
            dst.addObject((Object)e);
            this._deepRootLevelEventsFromEvents(e.subevents(), dst);
        }
    }

    public NSArray allEvents() {
        return this._events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray allEventsForAllCenters() {
        Collection ctrs;
        WeakHashMap weakHashMap = _centers;
        synchronized (weakHashMap) {
            ctrs = _centers.values();
        }
        Iterator iter = ctrs.iterator();
        NSMutableArray allEvents = new NSMutableArray();
        while (iter.hasNext()) {
            EOEventCenter evc = (EOEventCenter)iter.next();
            allEvents.addObjectsFromArray(evc.allEvents());
        }
        return allEvents;
    }

    public NSArray rootEvents() {
        NSMutableArray result = new NSMutableArray();
        for (EOEvent event = this._rootEvent; event != null; event = event._nextEvent()) {
            result.addObject((Object)event);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NSMutableArray _rootLevelEvents() {
        Collection ctrs;
        WeakHashMap weakHashMap = _centers;
        synchronized (weakHashMap) {
            ctrs = _centers.values();
        }
        Iterator iter = ctrs.iterator();
        NSMutableArray allEvents = new NSMutableArray();
        while (iter.hasNext()) {
            EOEventCenter evc = (EOEventCenter)iter.next();
            allEvents.addObjectsFromArray(evc.rootEvents());
        }
        return allEvents;
    }

    public static NSArray rootEventsForAllCenters() {
        return EOEventCenter._rootLevelEvents();
    }

    public static NSArray rootEventsByDuration() {
        NSMutableArray result = EOEventCenter._rootLevelEvents();
        try {
            result.sortUsingComparator((NSComparator)EOEvent.AscendingDurationComparator);
        }
        catch (NSComparator.ComparisonException exc) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)exc);
        }
        return result;
    }

    protected static final long _time() {
        return System.currentTimeMillis();
    }

    static {
        _centers = new WeakHashMap();
        _classesWithCallbacks = new NSMutableDictionary();
        _classesWithCallbacksState = new NSMutableDictionary();
        eventCenterClass = null;
        sleepy = 0;
        _loggingErrorAbort = false;
        logOverflow = false;
        eventLimit = 200000L;
        try {
            logOverflow = NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty((String)EventLoggingOverflowDisplay));
            defaultLoggingEnabled = NSPropertyListSerialization.booleanForString((String)NSProperties.getProperty((String)EventLoggingEnabled));
            _password = NSProperties.getProperty((String)EventLoggingPassword);
            int limit = NSPropertyListSerialization.intForString((String)NSProperties.getProperty((String)EventLoggingLimit));
            if (limit > 0) {
                eventLimit = limit;
            }
        }
        catch (SecurityException exception) {
            NSLog._conditionallyLogPrivateException((Throwable)exception);
        }
        _resetLoggingCall = new NSSelector("resetLogging", null);
        _setLoggingEnabledCall = new NSSelector("setLoggingEnabled", new Class[]{Boolean.TYPE, _NSUtilities._ClassClass});
    }

    public static interface EventRecordingHandler {
        public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.eocontrol.EOEventCenter$EventRecordingHandler");

        public void setLoggingEnabled(boolean var1, Class var2);
    }
}

