/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumTest
implements Cloneable {
    private static final Logger log = Logger.getLogger(SeleniumTest.class);
    protected NSMutableArray<Element> elements;
    protected String name;

    public SeleniumTest(String name) {
        this.name = name;
        this.elements = new NSMutableArray();
    }

    public SeleniumTest(String name, NSArray<Element> elements) {
        this.name = name;
        this.elements = new NSMutableArray(elements);
    }

    public SeleniumTest(String name, Element[] elements) {
        this.name = name;
        this.elements = new NSMutableArray((Object[])elements);
    }

    public NSArray<Element> elements() {
        return this.elements;
    }

    public void assignElements(NSArray<Element> elements) {
        assert (elements != null);
        this.elements = new NSMutableArray(elements);
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        assert (name != null);
        this.name = name;
    }

    public Object clone() {
        return new SeleniumTest(this.name, (NSArray<Element>)this.elements);
    }

    public void dump() {
        log.debug((Object)("Test name: " + this.name));
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            log.debug((Object)iter.next().toString());
        }
    }

    public static class Command
    extends Element {
        protected String name;
        protected String target;
        protected String value;

        public Command(String name, String target, String value) {
            assert (name != null);
            assert (target != null);
            assert (value != null);
            this.name = name;
            this.target = target;
            this.value = value;
        }

        public void setName(String name) {
            assert (name != null);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setTarget(String target) {
            assert (target != null);
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }

        public void setValue(String value) {
            assert (value != null);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Command clone() {
            return new Command(this.name, this.target, this.value);
        }

        public String toString() {
            return this.getClass().getCanonicalName() + ": name='" + this.name + "', target='" + this.target + "', value='" + this.value + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetaCommand
    extends Element {
        protected String name;
        protected NSMutableArray<String> arguments;

        public static MetaCommand metaCommandFromString(String str) {
            String[] args = str.split(" ");
            MetaCommand metaCommand = new MetaCommand(args[0]);
            for (int j = 1; j < args.length; ++j) {
                metaCommand.addArgument(args[j]);
            }
            return metaCommand;
        }

        public MetaCommand(String name) {
            assert (name != null);
            this.name = name;
            this.arguments = new NSMutableArray();
        }

        public MetaCommand(String name, NSArray<String> arguments) {
            assert (name != null);
            assert (arguments != null);
            this.name = name;
            this.arguments = new NSMutableArray(arguments);
        }

        public MetaCommand(String name, String[] arguments) {
            assert (name != null);
            assert (arguments != null);
            this.name = name;
            this.arguments = new NSMutableArray((Object[])arguments);
        }

        public void setName(String name) {
            assert (name != null);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addArgument(String argument) {
            assert (argument != null);
            this.arguments.add((Object)argument);
        }

        public NSArray<String> arguments() {
            return this.arguments;
        }

        public String argumentsString() {
            StringBuilder result = new StringBuilder();
            Iterator iter = this.arguments.iterator();
            while (iter.hasNext()) {
                result.append((String)iter.next());
                if (!iter.hasNext()) continue;
                result.append(' ');
            }
            return result.toString();
        }

        @Override
        public MetaCommand clone() {
            return new MetaCommand(this.name, (NSArray<String>)this.arguments);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getCanonicalName() + ": ");
            builder.append("@" + this.name + " ");
            Iterator iter = this.arguments.iterator();
            while (iter.hasNext()) {
                builder.append(((String)iter.next()).toString() + " ");
            }
            return builder.toString();
        }
    }

    public static class Comment
    extends Element {
        protected String value;

        public Comment(String value) {
            assert (value != null);
            this.value = value;
        }

        public void setValue(String value) {
            assert (value != null);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Comment clone() {
            return new Comment(this.value);
        }

        public String toString() {
            return this.getClass().getCanonicalName() + ": " + this.value;
        }
    }

    public static abstract class Element
    implements Cloneable {
        public abstract Element clone();
    }
}

