/*
 * Decompiled with CFR 0.152.
 */
package er.selenium;

import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXUtilities;
import er.selenium.SeleniumTest;
import er.selenium.filters.SeleniumTestFilter;
import er.selenium.io.SeleniumImporterExporterFactory;
import er.selenium.io.SeleniumTestImporter;
import java.io.File;
import org.apache.log4j.Logger;

public class SeleniumTestFileProcessor {
    private static final Logger log = Logger.getLogger(SeleniumTestFileProcessor.class);
    private final File testFile;
    private final SeleniumTestFilter filter;

    public SeleniumTestFileProcessor(File testFile, SeleniumTestFilter filter) {
        this.testFile = testFile;
        this.filter = filter;
    }

    public SeleniumTest process() {
        String extension = "." + ERXFileUtilities.fileExtension((String)this.testFile.getName());
        SeleniumTestImporter importer = SeleniumImporterExporterFactory.instance().findImporterByExtension(extension);
        if (importer == null) {
            throw new RuntimeException("Can't process '" + this.testFile.getAbsolutePath() + "': unsupported file type ('" + extension + "')");
        }
        try {
            String fileContents = ERXFileUtilities.stringFromFile((File)this.testFile, (String)"UTF-8");
            SeleniumTest result = importer.process(fileContents);
            if (this.filter != null) {
                result = this.filter.processTest(result);
            }
            return result;
        }
        catch (Exception e) {
            log.debug((Object)ERXUtilities.stackTrace((Throwable)e));
            throw new RuntimeException("Test import for '" + this.testFile.getAbsolutePath() + "' failed.", e);
        }
    }
}

