/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.filters;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import er.extensions.foundation.ERXFileUtilities;
import er.selenium.SeleniumTest;
import er.selenium.filters.SeleniumTestFilter;
import er.selenium.filters.SeleniumTestFilterHelper;
import er.selenium.io.SeleniumImporterExporterFactory;
import er.selenium.io.SeleniumTestImporter;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumIncludeTestFilter
extends SeleniumTestFilterHelper
implements SeleniumTestFilter {
    private static final Logger log = Logger.getLogger(SeleniumIncludeTestFilter.class);
    private static final int INCLUDE_LIMIT = 256;
    private final NSArray<File> _searchPaths;

    public SeleniumIncludeTestFilter(NSArray<File> searchPaths) {
        this._searchPaths = searchPaths;
    }

    protected NSArray<SeleniumTest.Element> getIncludedArguments(String name) {
        SeleniumTestImporter importer = SeleniumImporterExporterFactory.instance().findImporterByExtension('.' + ERXFileUtilities.fileExtension((String)name));
        if (importer == null) {
            throw new RuntimeException("Can't find importer for included test file: " + name);
        }
        for (File sp : this._searchPaths) {
            String fileContents;
            File fio = new File(sp.getAbsolutePath() + "/" + name);
            if (!fio.exists()) continue;
            try {
                fileContents = ERXFileUtilities.stringFromFile((File)fio, (String)"UTF-8");
            }
            catch (IOException e) {
                log.error((Object)("Can't read " + fio.getAbsolutePath() + " contents"));
                throw new RuntimeException(e);
            }
            SeleniumTest processedTest = importer.process(fileContents);
            return processedTest.elements();
        }
        throw new RuntimeException("Included path not found: " + name);
    }

    @Override
    protected void processTestElements(NSMutableArray<SeleniumTest.Element> elements) {
        int includeCount = 0;
        for (int i = 0; i < elements.count(); ++i) {
            SeleniumTest.MetaCommand metaCommand;
            SeleniumTest.Element element = (SeleniumTest.Element)elements.get(i);
            if (!(element instanceof SeleniumTest.MetaCommand) || !(metaCommand = (SeleniumTest.MetaCommand)element).getName().equals("include")) continue;
            if (includeCount >= 256) {
                throw new RuntimeException("Too many @include commands (recursive include?)");
            }
            NSArray<SeleniumTest.Element> newElements = this.getIncludedArguments(metaCommand.argumentsString());
            NSArray tailElements = elements.subarrayWithRange(new NSRange(i + 1, elements.count() - i - 1));
            elements.removeObjectsInRange(new NSRange(i, elements.count() - i));
            elements.addObjectsFromArray(newElements);
            elements.addObjectsFromArray(tailElements);
            ++includeCount;
        }
    }
}

