/*
 * Decompiled with CFR 0.152.
 */
package er.selenium.filters;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.selenium.SeleniumTest;
import er.selenium.filters.SeleniumTestFilter;
import er.selenium.filters.SeleniumTestFilterHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumRepeatExpanderTestFilter
extends SeleniumTestFilterHelper
implements SeleniumTestFilter {
    private static final Logger log = Logger.getLogger(SeleniumRepeatExpanderTestFilter.class);

    protected void generateIterations(NSMutableArray<SeleniumTest.Element> elements, int repeatIndex, int doneIndex) {
        NSMutableDictionary loopData = new NSMutableDictionary();
        int repetitionCount = -1;
        for (int i = repeatIndex + 1; i < doneIndex; ++i) {
            SeleniumTest.MetaCommand metaCommand;
            String mcName;
            SeleniumTest.Element element = (SeleniumTest.Element)elements.get(i);
            if (!(element instanceof SeleniumTest.MetaCommand) || !(mcName = (metaCommand = (SeleniumTest.MetaCommand)element).getName()).equals("values") && !mcName.equals("targets")) continue;
            if (!(elements.get(i + 1) instanceof SeleniumTest.Command)) {
                throw new RuntimeException("There must be a valid command immediately after 'values' or 'targets' metacommand");
            }
            int relTargetIndex = i + 1 - repeatIndex;
            loopData.setObjectForKey((Object)new LoopData(metaCommand.arguments(), relTargetIndex, mcName.equals("values") ? LoopData.PlacementType.Value : LoopData.PlacementType.Target), (Object)new Integer(relTargetIndex));
            repetitionCount = metaCommand.arguments().count();
            elements.set(i, (Object)new SeleniumTest.Comment('#' + mcName));
        }
        if (loopData.count() == 0) {
            throw new RuntimeException("No 'values' or 'targets' metacommands specified between 'repeat' and 'done'");
        }
        for (LoopData ld : loopData.allValues()) {
            if (ld.values.count() == repetitionCount) continue;
            throw new RuntimeException("All 'values' and 'targets' metacommands inside 'repeat'-'done' repetition must have equal number of arguments");
        }
        elements.set(repeatIndex, (Object)new SeleniumTest.Comment("#repeat"));
        elements.set(doneIndex, (Object)new SeleniumTest.Comment("#done"));
        int insertIndex = doneIndex;
        for (int j = 0; j < repetitionCount; ++j) {
            elements.insertObjectAtIndex((Object)new SeleniumTest.Comment("#iteration"), insertIndex++);
            for (int i = repeatIndex + 1; i < doneIndex; ++i) {
                LoopData data = (LoopData)loopData.objectForKey((Object)new Integer(i - repeatIndex));
                if (data != null) {
                    SeleniumTest.Command newCommand = ((SeleniumTest.Command)elements.objectAtIndex(i)).clone();
                    switch (data.placement) {
                        case Target: {
                            elements.insertObjectAtIndex((Object)new SeleniumTest.Comment("#target " + (String)data.values.get(j)), insertIndex++);
                            newCommand.setTarget((String)data.values.get(j));
                            break;
                        }
                        case Value: {
                            elements.insertObjectAtIndex((Object)new SeleniumTest.Comment("#value " + (String)data.values.get(j)), insertIndex++);
                            newCommand.setValue((String)data.values.get(j));
                            break;
                        }
                    }
                    elements.insertObjectAtIndex((Object)newCommand, insertIndex++);
                    continue;
                }
                elements.insertObjectAtIndex((Object)((SeleniumTest.Element)elements.get(i)).clone(), insertIndex++);
            }
        }
    }

    @Override
    protected void processTestElements(NSMutableArray<SeleniumTest.Element> elements) {
        boolean shouldProcess;
        int repeatIndex = -1;
        do {
            shouldProcess = false;
            for (int i = 0; i < elements.count(); ++i) {
                SeleniumTest.Element element = (SeleniumTest.Element)elements.get(i);
                if (!(element instanceof SeleniumTest.MetaCommand)) continue;
                SeleniumTest.MetaCommand metaCommand = (SeleniumTest.MetaCommand)element;
                if (metaCommand.getName().equals("repeat")) {
                    repeatIndex = i;
                    continue;
                }
                if (!metaCommand.getName().equals("done")) continue;
                this.generateIterations(elements, repeatIndex, i);
                shouldProcess = true;
            }
        } while (shouldProcess);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LoopData {
        NSArray<String> values;
        int targetOffset;
        PlacementType placement;

        LoopData(NSArray<String> aValues, int aTargetOffset, PlacementType aPlacement) {
            this.values = aValues;
            this.targetOffset = aTargetOffset;
            this.placement = aPlacement;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum PlacementType {
            Target,
            Value;

        }
    }
}

