/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectstyle.cayenne.CayenneContextGraphAction;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.FaultFailureException;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectContextGraphManager;
import org.objectstyle.cayenne.ObjectContextMergeHandler;
import org.objectstyle.cayenne.ObjectContextUtils;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.QueryResponse;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.GraphEventListener;
import org.objectstyle.cayenne.graph.GraphManager;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.query.ObjectIdQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.util.ObjectContextQueryAction;

public class CayenneContext
implements ObjectContext {
    protected transient DataChannel channel;
    protected EntityResolver entityResolver;
    ObjectContextGraphManager graphManager;
    CayenneContextGraphAction graphAction = new CayenneContextGraphAction(this);
    ObjectContextMergeHandler mergeHandler;

    public CayenneContext() {
        this(null);
    }

    public CayenneContext(DataChannel channel) {
        this(channel, false, false);
    }

    public CayenneContext(DataChannel channel, boolean changeEventsEnabled, boolean syncEventsEnabled) {
        this.graphManager = new ObjectContextGraphManager(this, changeEventsEnabled, syncEventsEnabled);
        this.setChannel(channel);
    }

    public DataChannel getChannel() {
        return this.channel;
    }

    public void setChannel(DataChannel channel) {
        if (this.channel != channel) {
            EventManager eventManager;
            if (this.mergeHandler != null) {
                this.mergeHandler.active = false;
                this.mergeHandler = null;
            }
            this.channel = channel;
            EventManager eventManager2 = eventManager = channel != null ? channel.getEventManager() : null;
            if (eventManager != null) {
                this.mergeHandler = new ObjectContextMergeHandler(this);
                ObjectContextUtils.listenForChannelEvents(channel, (GraphEventListener)this.mergeHandler);
            }
        }
    }

    public boolean isChangeEventsEnabled() {
        return this.graphManager.changeEventsEnabled;
    }

    public boolean isLifecycleEventsEnabled() {
        return this.graphManager.lifecycleEventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            CayenneContext cayenneContext = this;
            synchronized (cayenneContext) {
                if (this.entityResolver == null) {
                    this.setEntityResolver(this.channel.getEntityResolver());
                }
            }
        }
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    ObjectContextGraphManager internalGraphManager() {
        return this.graphManager;
    }

    CayenneContextGraphAction internalGraphAction() {
        return this.graphAction;
    }

    public void commitChanges() {
        this.doCommitChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff doCommitChanges() {
        GraphDiff commitDiff = null;
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                this.graphManager.graphCommitStarted();
                try {
                    commitDiff = this.channel.onSync(this, this.graphManager.getDiffsSinceLastFlush(), 2);
                }
                catch (Throwable th) {
                    this.graphManager.graphCommitAborted();
                    if (th instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)th;
                    }
                    throw new CayenneRuntimeException("Commit error", th);
                }
                this.graphManager.graphCommitted(commitDiff);
            }
        }
        return commitDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChanges() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                GraphDiff diff = this.graphManager.getDiffs();
                this.graphManager.graphReverted();
                this.channel.onSync(this, diff, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChangesToParent() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            if (this.graphManager.hasChangesSinceLastFlush()) {
                GraphDiff diff = this.graphManager.getDiffsSinceLastFlush();
                this.graphManager.graphFlushed();
                this.channel.onSync(this, diff, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackChangesLocally() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            if (this.graphManager.hasChanges()) {
                this.graphManager.graphReverted();
            }
        }
    }

    public void deleteObject(Persistent object) {
        if (object.getPersistenceState() == 1) {
            return;
        }
        if (object.getPersistenceState() == 6) {
            return;
        }
        if (object.getPersistenceState() == 2) {
            object.setPersistenceState(1);
            this.graphManager.unregisterNode(object.getObjectId());
            return;
        }
        object.setPersistenceState(6);
        this.graphManager.nodeRemoved(object.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent newObject(Class persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Persistent class can't be null.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(persistentClass);
        if (entity == null) {
            throw new CayenneRuntimeException("No entity mapped for class: " + persistentClass);
        }
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            return this.createNewObject(new ObjectId(entity.getName()));
        }
    }

    public List performQuery(Query query) {
        List result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    public QueryResponse performGenericQuery(Query query) {
        return this.onQuery(this, query);
    }

    QueryResponse onQuery(ObjectContext context, Query query) {
        return new ObjectContextQueryAction(this, context, query).execute();
    }

    public Persistent localObject(ObjectId id, Persistent prototype) {
        if (id == null) {
            throw new IllegalArgumentException("Null ObjectId");
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        Persistent cachedObject = (Persistent)this.getGraphManager().getNode(id);
        if (cachedObject != null) {
            if (cachedObject != prototype && cachedObject.getPersistenceState() != 4 && cachedObject.getPersistenceState() != 6) {
                descriptor.injectValueHolders(cachedObject);
                if (prototype != null && prototype.getPersistenceState() != 5) {
                    descriptor.shallowMerge(prototype, cachedObject);
                    if (cachedObject.getPersistenceState() == 5) {
                        cachedObject.setPersistenceState(3);
                    }
                }
            }
            return cachedObject;
        }
        Persistent localObject = (Persistent)descriptor.createObject();
        localObject.setObjectContext(this);
        localObject.setObjectId(id);
        this.getGraphManager().registerNode(id, localObject);
        if (prototype != null) {
            localObject.setPersistenceState(3);
            descriptor.injectValueHolders(localObject);
            descriptor.shallowMerge(prototype, localObject);
        } else {
            localObject.setPersistenceState(5);
        }
        return localObject;
    }

    public void prepareForAccess(Persistent object, String property) {
        if (object.getPersistenceState() == 5) {
            ObjectId gid = object.getObjectId();
            List objects = this.performQuery(new ObjectIdQuery(gid));
            if (objects.size() == 0) {
                throw new FaultFailureException("Error resolving fault, no matching row exists in the database for GlobalID: " + gid);
            }
            if (objects.size() > 1) {
                throw new FaultFailureException("Error resolving fault, more than one row exists in the database for GlobalID: " + gid);
            }
        }
    }

    public void propertyChanged(Persistent object, String property, Object oldValue, Object newValue) {
        this.graphAction.handlePropertyChange(object, property, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection uncommittedObjects() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            return this.graphManager.dirtyNodes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection deletedObjects() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            return this.graphManager.dirtyNodes(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection modifiedObjects() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            return this.graphManager.dirtyNodes(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection newObjects() {
        ObjectContextGraphManager objectContextGraphManager = this.graphManager;
        synchronized (objectContextGraphManager) {
            return this.graphManager.dirtyNodes(2);
        }
    }

    Persistent createNewObject(ObjectId id) {
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        Persistent object = (Persistent)descriptor.createObject();
        object.setPersistenceState(2);
        object.setObjectContext(this);
        object.setObjectId(id);
        descriptor.injectValueHolders(object);
        this.graphManager.registerNode(object.getObjectId(), object);
        this.graphManager.nodeCreated(object.getObjectId());
        return object;
    }

    Persistent createFault(ObjectId id) {
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
        Persistent object = (Persistent)descriptor.createObject();
        object.setPersistenceState(5);
        object.setObjectContext(this);
        object.setObjectId(id);
        descriptor.injectValueHolders(object);
        this.graphManager.registerNode(id, object);
        return object;
    }
}

