/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.Fault;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.PersistenceState;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.property.PropertyUtils;
import org.objectstyle.cayenne.validation.BeanValidationFailure;
import org.objectstyle.cayenne.validation.ValidationFailure;
import org.objectstyle.cayenne.validation.ValidationResult;
import org.objectstyle.cayenne.xml.XMLDecoder;
import org.objectstyle.cayenne.xml.XMLEncoder;
import org.objectstyle.cayenne.xml.XMLSerializable;

public class CayenneDataObject
implements DataObject,
XMLSerializable {
    protected long snapshotVersion = Long.MIN_VALUE;
    protected ObjectId objectId;
    protected transient int persistenceState = 1;
    protected transient ObjectContext objectContext;
    protected Map values = new HashMap();

    public DataContext getDataContext() {
        if (this.objectContext == null || this.objectContext instanceof DataContext) {
            return (DataContext)this.objectContext;
        }
        throw new CayenneRuntimeException("ObjectContext is not a DataContext: " + this.objectContext);
    }

    public void setDataContext(DataContext dataContext) {
        this.objectContext = dataContext;
        if (dataContext == null) {
            this.persistenceState = 1;
        }
    }

    public ObjEntity getObjEntity() {
        return this.getObjectContext() != null ? this.getObjectContext().getEntityResolver().lookupObjEntity(this) : null;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public int getPersistenceState() {
        return this.persistenceState;
    }

    public void setPersistenceState(int persistenceState) {
        this.persistenceState = persistenceState;
        if (persistenceState == 5) {
            this.values.clear();
        }
    }

    public Object readNestedProperty(String path) {
        Object object = null;
        CayenneDataObject dataObject = this;
        String[] tokenized = CayenneDataObject.tokenizePath(path);
        int length = tokenized.length;
        int pathIndex = 0;
        for (int i = 0; i < length; ++i) {
            pathIndex += tokenized[i].length();
            object = dataObject.readSimpleProperty(tokenized[i]);
            if (object == null) {
                return null;
            }
            if (object instanceof CayenneDataObject) {
                dataObject = (CayenneDataObject)object;
                continue;
            }
            if (i + 1 >= length) continue;
            return PropertyUtils.getProperty(object, path.substring(pathIndex));
        }
        return object;
    }

    private static final String[] tokenizePath(String path) {
        if (path == null) {
            throw new NullPointerException("Null property path.");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Empty property path.");
        }
        if (path.indexOf(".") < 0) {
            return new String[]{path};
        }
        StringTokenizer tokens = new StringTokenizer(path, ".");
        int length = tokens.countTokens();
        String[] tokenized = new String[length];
        for (int i = 0; i < length; ++i) {
            tokenized[i] = tokens.nextToken();
        }
        return tokenized;
    }

    private final Object readSimpleProperty(String property) {
        Object object = this.readProperty(property);
        if (object == null && !this.values.containsKey(property)) {
            object = PropertyUtils.getProperty(this, property);
        }
        return object;
    }

    public void resolveFault() {
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, null);
        }
    }

    public Object readProperty(String propName) {
        Object object;
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, propName);
        }
        if ((object = this.readPropertyDirectly(propName)) instanceof Fault) {
            object = ((Fault)object).resolveFault(this, propName);
            this.writePropertyDirectly(propName, object);
        }
        return object;
    }

    public Object readPropertyDirectly(String propName) {
        return this.values.get(propName);
    }

    public void writeProperty(String propName, Object val) {
        if (this.objectContext != null) {
            this.objectContext.prepareForAccess(this, propName);
            Object oldValue = this.readPropertyDirectly(propName);
            this.objectContext.propertyChanged(this, propName, oldValue, val);
        }
        this.writePropertyDirectly(propName, val);
    }

    public void writePropertyDirectly(String propName, Object val) {
        this.values.put(propName, val);
    }

    public void removeToManyTarget(String relName, DataObject value, boolean setReverse) {
        List relList = (List)this.readProperty(relName);
        this.getDataContext().getObjectStore().recordArcDeleted(this, value != null ? value.getObjectId() : null, relName);
        relList.remove(value);
        if (this.persistenceState == 3) {
            this.persistenceState = 4;
        }
        if (value != null && setReverse) {
            this.unsetReverseRelationship(relName, value);
        }
    }

    public void addToManyTarget(String relName, DataObject value, boolean setReverse) {
        if (value == null) {
            throw new NullPointerException("Attempt to add null target DataObject.");
        }
        this.willConnect(relName, value);
        List list = (List)this.readProperty(relName);
        this.getDataContext().getObjectStore().recordArcCreated(this, value.getObjectId(), relName);
        list.add(value);
        if (value != null && setReverse) {
            this.setReverseRelationship(relName, value);
        }
    }

    public void setToOneTarget(String relationshipName, DataObject value, boolean setReverse) {
        this.willConnect(relationshipName, value);
        Object oldTarget = this.readProperty(relationshipName);
        if (oldTarget == value) {
            return;
        }
        this.getDataContext().getObjectStore().recordArcCreated(this, value != null ? value.getObjectId() : null, relationshipName);
        if (setReverse) {
            if (oldTarget instanceof DataObject) {
                this.unsetReverseRelationship(relationshipName, (DataObject)oldTarget);
            }
            if (value != null) {
                this.setReverseRelationship(relationshipName, value);
            }
        }
        this.objectContext.prepareForAccess(this, relationshipName);
        this.writePropertyDirectly(relationshipName, value);
    }

    protected void willConnect(String relationshipName, DataObject dataObject) {
        if (dataObject == null || this.getObjectContext() == dataObject.getObjectContext()) {
            return;
        }
        if (this.getObjectContext() == null && dataObject.getObjectContext() != null) {
            dataObject.getDataContext().registerNewObject(this);
        } else if (this.getObjectContext() != null && dataObject.getObjectContext() == null) {
            this.getDataContext().registerNewObject(dataObject);
        } else {
            throw new CayenneRuntimeException("Cannot set object as destination of relationship " + relationshipName + " because it is in a different DataContext");
        }
    }

    protected void setReverseRelationship(String relName, DataObject val) {
        ObjRelationship rel = (ObjRelationship)this.objectContext.getEntityResolver().lookupObjEntity(this.objectId.getEntityName()).getRelationship(relName);
        ObjRelationship revRel = rel.getReverseRelationship();
        if (revRel != null) {
            if (revRel.isToMany()) {
                val.addToManyTarget(revRel.getName(), this, false);
            } else {
                val.setToOneTarget(revRel.getName(), this, false);
            }
        }
    }

    protected void unsetReverseRelationship(String relName, DataObject val) {
        EntityResolver resolver = this.objectContext.getEntityResolver();
        ObjEntity entity = resolver.lookupObjEntity(this.objectId.getEntityName());
        if (entity == null) {
            throw new IllegalStateException("DataObject's entity is unmapped, objectId: " + this.objectId);
        }
        ObjRelationship rel = (ObjRelationship)entity.getRelationship(relName);
        ObjRelationship revRel = rel.getReverseRelationship();
        if (revRel != null) {
            if (revRel.isToMany()) {
                val.removeToManyTarget(revRel.getName(), this, false);
            } else {
                val.setToOneTarget(revRel.getName(), null, false);
            }
        }
    }

    public StringBuffer toStringBuffer(StringBuffer buffer, boolean fullDesc) {
        String id = this.objectId != null ? this.objectId.toString() : "<no id>";
        String state = PersistenceState.persistenceStateName(this.persistenceState);
        buffer.append('{').append(id).append("; ").append(state).append("; ");
        if (fullDesc) {
            this.appendProperties(buffer);
        }
        buffer.append("}");
        return buffer;
    }

    protected void appendProperties(StringBuffer buffer) {
        buffer.append("[");
        Iterator it = this.values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            buffer.append(entry.getKey()).append("=>");
            Object value = entry.getValue();
            if (value instanceof Persistent) {
                buffer.append('{').append(((Persistent)value).getObjectId()).append('}');
            } else if (value instanceof Collection) {
                buffer.append("(..)");
            } else if (value instanceof Fault) {
                buffer.append('?');
            } else {
                buffer.append(value);
            }
            if (!it.hasNext()) continue;
            buffer.append("; ");
        }
        buffer.append("]");
    }

    public String toString() {
        return this.toStringBuffer(new StringBuffer(), true).toString();
    }

    public void fetchFinished() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.persistenceState);
        switch (this.persistenceState) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                out.writeObject(this.values);
            }
        }
        out.writeObject(this.objectId);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.persistenceState = in.readInt();
        switch (this.persistenceState) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.values = (Map)in.readObject();
                break;
            }
            case 3: 
            case 5: {
                this.persistenceState = 5;
                this.values = new HashMap();
            }
        }
        this.objectId = (ObjectId)in.readObject();
    }

    public long getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public void setSnapshotVersion(long snapshotVersion) {
        this.snapshotVersion = snapshotVersion;
    }

    protected void validateForSave(ValidationResult validationResult) {
        ObjEntity objEntity = this.getDataContext().getEntityResolver().lookupObjEntity(this);
        if (objEntity == null) {
            throw new CayenneRuntimeException("No ObjEntity mapping found for DataObject " + this.getClass().getName());
        }
        DataNode node = this.getDataContext().getParentDataDomain().lookupDataNode(objEntity.getDataMap());
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode found for objEntity: " + objEntity.getName());
        }
        ExtendedTypeMap types = node.getAdapter().getExtendedTypes();
        HashMap<String, ValidationFailure> failedDbAttributes = null;
        Iterator attributes = objEntity.getAttributes().iterator();
        while (attributes.hasNext()) {
            ValidationFailure failure;
            ObjAttribute objAttribute = (ObjAttribute)attributes.next();
            DbAttribute dbAttribute = objAttribute.getDbAttribute();
            Object value = this.readPropertyDirectly(objAttribute.getName());
            if (dbAttribute.isMandatory() && (failure = BeanValidationFailure.validateNotNull(this, objAttribute.getName(), value)) != null) {
                if (failedDbAttributes == null) {
                    failedDbAttributes = new HashMap<String, ValidationFailure>();
                }
                failedDbAttributes.put(dbAttribute.getName(), failure);
                continue;
            }
            if (value == null) continue;
            types.getRegisteredType(value.getClass()).validateProperty(this, objAttribute.getName(), value, dbAttribute, validationResult);
        }
        Iterator relationships = objEntity.getRelationships().iterator();
        while (relationships.hasNext()) {
            List dbRels;
            ObjRelationship relationship = (ObjRelationship)relationships.next();
            if (relationship.isSourceIndependentFromTargetChange() || (dbRels = relationship.getDbRelationships()).isEmpty()) continue;
            boolean validate = true;
            DbRelationship dbRelationship = (DbRelationship)dbRels.get(0);
            Iterator joins = dbRelationship.getJoins().iterator();
            while (joins.hasNext()) {
                DbJoin join = (DbJoin)joins.next();
                DbAttribute source = join.getSource();
                if (source.isMandatory()) {
                    if (failedDbAttributes == null || failedDbAttributes.isEmpty()) continue;
                    failedDbAttributes.remove(source.getName());
                    if (failedDbAttributes.isEmpty()) continue;
                    continue;
                }
                validate = false;
            }
            if (!validate) continue;
            Object value = this.readPropertyDirectly(relationship.getName());
            ValidationFailure failure = BeanValidationFailure.validateNotNull(this, relationship.getName(), value);
            if (failure == null) continue;
            validationResult.addFailure(failure);
        }
        if (failedDbAttributes != null && !failedDbAttributes.isEmpty()) {
            Iterator failedAttributes = failedDbAttributes.values().iterator();
            while (failedAttributes.hasNext()) {
                validationResult.addFailure((ValidationFailure)failedAttributes.next());
            }
        }
    }

    public void validateForInsert(ValidationResult validationResult) {
        this.validateForSave(validationResult);
    }

    public void validateForUpdate(ValidationResult validationResult) {
        this.validateForSave(validationResult);
    }

    public void validateForDelete(ValidationResult validationResult) {
    }

    public void encodeAsXML(XMLEncoder encoder) {
        EntityResolver er = this.getDataContext().getEntityResolver();
        ObjEntity object = er.lookupObjEntity(this.getClass());
        String[] fields = this.getClass().getName().split("\\.");
        encoder.setRoot(fields[fields.length - 1], this.getClass().getName());
        Iterator it = object.getDeclaredAttributes().iterator();
        while (it.hasNext()) {
            ObjAttribute att = (ObjAttribute)it.next();
            String name = att.getName();
            encoder.encodeProperty(name, this.readNestedProperty(name));
        }
    }

    public void decodeFromXML(XMLDecoder decoder) {
        DataNode dn;
        EntityResolver er;
        ObjEntity object = null;
        Iterator it = Configuration.getSharedConfiguration().getDomain().getDataNodes().iterator();
        while (it.hasNext() && null == (object = (er = (dn = (DataNode)it.next()).getEntityResolver()).lookupObjEntity(this.getClass()))) {
        }
        it = object.getDeclaredAttributes().iterator();
        while (it.hasNext()) {
            ObjAttribute att = (ObjAttribute)it.next();
            String name = att.getName();
            this.writeProperty(name, decoder.decodeObject(name));
        }
    }

    public ObjectContext getObjectContext() {
        return this.objectContext;
    }

    public void setObjectContext(ObjectContext objectContext) {
        this.objectContext = objectContext;
        if (objectContext == null) {
            this.persistenceState = 1;
        }
    }
}

