/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.util.Util;

public class DataRow
extends HashMap {
    private static volatile long currentVersion = -9223372036854775807L;
    protected long version = currentVersion++;
    protected long replacesVersion = Long.MIN_VALUE;

    public DataRow(Map map) {
        super(map);
    }

    public DataRow(int initialCapacity) {
        super(initialCapacity);
    }

    public long getVersion() {
        return this.version;
    }

    public long getReplacesVersion() {
        return this.replacesVersion;
    }

    public void setReplacesVersion(long replacesVersion) {
        this.replacesVersion = replacesVersion;
    }

    public DataRow applyDiff(DataRow diff) {
        DataRow merged = new DataRow((Map)this);
        Iterator it = diff.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            merged.put(entry.getKey(), entry.getValue());
        }
        return merged;
    }

    public DataRow createDiff(DataRow row) {
        HashMap diff = null;
        Iterator entries = this.entrySet().iterator();
        while (entries.hasNext()) {
            Object rowValue;
            Map.Entry entry = entries.next();
            Object key = entry.getKey();
            Object currentValue = entry.getValue();
            if (Util.nullSafeEquals(currentValue, rowValue = row.get(key))) continue;
            if (diff == null) {
                diff = new DataRow(this.size());
            }
            diff.put(key, rowValue);
        }
        return diff;
    }

    public ObjectId createObjectId(ObjEntity entity) {
        return this.createObjectId(entity.getName(), entity.getDbEntity());
    }

    public ObjectId createObjectId(Class objectClass, DbEntity entity) {
        return this.createObjectId(ObjectId.entityNameFromClass(objectClass), entity);
    }

    public ObjectId createTargetObjectId(Class targetClass, DbRelationship relationship) {
        return this.createTargetObjectId(ObjectId.entityNameFromClass(targetClass), relationship);
    }

    public ObjectId createObjectId(String entityName, DbEntity entity) {
        return this.createObjectId(entityName, entity, null);
    }

    public ObjectId createTargetObjectId(String entityName, DbRelationship relationship) {
        if (relationship.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' can have a target ObjectId.");
        }
        Map target = relationship.targetPkSnapshotWithSrcSnapshot(this);
        return target != null ? new ObjectId(entityName, target) : null;
    }

    public ObjectId createObjectId(String entityName, DbEntity entity, String namePrefix) {
        boolean prefix = namePrefix != null && namePrefix.length() > 0;
        List pk = entity.getPrimaryKey();
        if (pk.size() == 1) {
            DbAttribute attribute = (DbAttribute)pk.get(0);
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = this.get(key);
            if (val == null) {
                throw new CayenneRuntimeException("Null value for '" + key + "'. Snapshot: " + this + ". Prefix: " + namePrefix);
            }
            return new ObjectId(entityName, attribute.getName(), val);
        }
        HashMap idMap = new HashMap(pk.size() * 2);
        Iterator it = pk.iterator();
        while (it.hasNext()) {
            DbAttribute attribute = (DbAttribute)it.next();
            String key = prefix ? namePrefix + attribute.getName() : attribute.getName();
            Object val = this.get(key);
            if (val == null) {
                throw new CayenneRuntimeException("Null value for '" + key + "'. Snapshot: " + this + ". Prefix: " + namePrefix);
            }
            idMap.put(attribute.getName(), val);
        }
        return new ObjectId(entityName, idMap);
    }

    public String toString() {
        return new ToStringBuilder(this).append("values", super.toString()).append(" version", this.version).append(" replaces", this.replacesVersion).toString();
    }
}

