/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.objectstyle.cayenne.util.IDUtil;
import org.objectstyle.cayenne.util.Util;

public class ObjectId
implements Serializable {
    protected String entityName;
    protected Map objectIdKeys;
    protected byte[] key;
    protected Map replacementIdMap;
    transient int hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    static final String entityNameFromClass(Class javaClass) {
        if (javaClass == null) {
            return null;
        }
        String fqn = javaClass.getName();
        int dot = fqn.lastIndexOf(46);
        return dot > 0 ? fqn.substring(dot + 1) : fqn;
    }

    private ObjectId() {
    }

    public ObjectId(String entityName) {
        this.entityName = entityName;
        this.key = IDUtil.pseudoUniqueByteSequence8();
    }

    public ObjectId(String entityName, byte[] key) {
        this.entityName = entityName;
        this.key = key;
    }

    public ObjectId(String entityName, String key, int value) {
        this(entityName, key, (Object)new Integer(value));
    }

    public ObjectId(String entityName, String key, Object value) {
        this.entityName = entityName;
        this.objectIdKeys = new HashMap(1);
        this.objectIdKeys.put(key, value);
    }

    public ObjectId(String entityName, Map idMap) {
        this.entityName = entityName;
        this.objectIdKeys = idMap != null && !idMap.isEmpty() ? new HashMap(idMap) : null;
    }

    public ObjectId(Class objectClass) {
        this(ObjectId.entityNameFromClass(objectClass));
    }

    public ObjectId(Class objectClass, String keyName, int id) {
        this(ObjectId.entityNameFromClass(objectClass), keyName, (Object)new Integer(id));
    }

    public ObjectId(Class objectClass, String keyName, Object id) {
        this(ObjectId.entityNameFromClass(objectClass), keyName, id);
    }

    public ObjectId(Class objectClass, Map idKeys) {
        this(ObjectId.entityNameFromClass(objectClass), idKeys);
    }

    public boolean isTemporary() {
        return this.key != null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public byte[] getKey() {
        return this.key;
    }

    protected void setIdKeys(Map idKeys) {
        this.objectIdKeys = idKeys;
    }

    public Map getIdSnapshot() {
        if (this.isTemporary()) {
            return this.replacementIdMap == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.replacementIdMap);
        }
        return this.objectIdKeys != null ? Collections.unmodifiableMap(this.objectIdKeys) : Collections.EMPTY_MAP;
    }

    public Object getValueForAttribute(String attrName) {
        return this.getIdSnapshot().get(attrName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectId)) {
            return false;
        }
        ObjectId id = (ObjectId)object;
        if (!Util.nullSafeEquals(this.entityName, id.entityName)) {
            return false;
        }
        if (this.isTemporary()) {
            return new EqualsBuilder().append(this.key, id.key).isEquals();
        }
        if (id.objectIdKeys == null && this.objectIdKeys == null) {
            return true;
        }
        if (id.objectIdKeys == null || this.objectIdKeys == null) {
            return false;
        }
        if (id.objectIdKeys.size() != this.objectIdKeys.size()) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Iterator entries = this.objectIdKeys.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                if (id.objectIdKeys.get(entryKey) == null && id.objectIdKeys.containsKey(entryKey)) continue;
                return false;
            }
            builder.append(entryValue, id.objectIdKeys.get(entryKey));
            if (builder.isEquals()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(3, 5);
            builder.append(this.entityName.hashCode());
            if (this.key != null) {
                builder.append(this.key);
            } else if (this.objectIdKeys != null) {
                int len = this.objectIdKeys.size();
                if (len == 1) {
                    Iterator entries = this.objectIdKeys.entrySet().iterator();
                    Map.Entry entry = entries.next();
                    builder.append(entry.getKey()).append(entry.getValue());
                } else {
                    Object[] keys = this.objectIdKeys.keySet().toArray();
                    Arrays.sort(keys);
                    for (int i = 0; i < len; ++i) {
                        builder.append(i).append(this.objectIdKeys.get(keys[i]));
                    }
                }
            }
            this.hashCode = builder.toHashCode();
            if (!$assertionsDisabled && this.hashCode == 0) {
                throw new AssertionError((Object)"Generated zero hashCode");
            }
        }
        return this.hashCode;
    }

    public ObjectId getReplacementId() {
        return this.isReplacementIdAttached() ? this.createReplacementId() : null;
    }

    public void setReplacementId(ObjectId replacementId) {
        if (replacementId == null) {
            this.replacementIdMap = null;
        } else {
            Map map = this.getReplacementIdMap();
            map.clear();
            map.putAll(replacementId.getIdSnapshot());
        }
    }

    public Map getReplacementIdMap() {
        if (this.replacementIdMap == null) {
            this.replacementIdMap = new HashMap();
        }
        return this.replacementIdMap;
    }

    public ObjectId createReplacementId() {
        return new ObjectId(this.getEntityName(), this.replacementIdMap);
    }

    public boolean isReplacementIdAttached() {
        return this.replacementIdMap != null && !this.replacementIdMap.isEmpty();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<ObjectId:").append(this.entityName);
        if (this.isTemporary()) {
            buffer.append(", TEMP:");
            for (int i = 0; i < this.key.length; ++i) {
                IDUtil.appendFormattedByte(buffer, this.key[i]);
            }
        } else if (this.objectIdKeys != null) {
            Iterator it = this.objectIdKeys.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buffer.append(", ");
                buffer.append(String.valueOf(entry.getKey())).append("=").append(entry.getValue());
            }
        }
        buffer.append(">");
        return buffer.toString();
    }

    static {
        $assertionsDisabled = !ObjectId.class.desiredAssertionStatus();
    }
}

