/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphManager;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.Relationship;

class ChildDiffLoader
implements GraphChangeHandler {
    DataContext context;
    GraphManager graphManager;

    ChildDiffLoader(DataContext context) {
        this.context = context;
        this.graphManager = context.getGraphManager();
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        throw new CayenneRuntimeException("Not supported");
    }

    public void nodeCreated(Object nodeId) {
        ObjectId id = (ObjectId)nodeId;
        if (id.getEntityName() == null) {
            throw new NullPointerException("Null entity name in id " + id);
        }
        ObjEntity entity = this.context.getEntityResolver().lookupObjEntity(id.getEntityName());
        if (entity == null) {
            throw new IllegalArgumentException("Entity not mapped with Cayenne: " + id);
        }
        DataObject dataObject = null;
        try {
            dataObject = (DataObject)entity.getJavaClass().newInstance();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating object.", ex);
        }
        dataObject.setObjectId(id);
        this.context.registerNewObject(dataObject);
    }

    public void nodeRemoved(Object nodeId) {
        DataObject object = this.findObject(nodeId);
        this.context.deleteObject(object);
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        DataObject object = this.findObject(nodeId);
        try {
            object.writeProperty(property, newValue);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error setting property: " + property, e);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        DataObject source = this.findObject(nodeId);
        ObjEntity sourceEntity = this.context.getEntityResolver().lookupObjEntity(source);
        Relationship relationship = sourceEntity.getRelationship(arcId.toString());
        DataObject target = this.findObject(targetNodeId);
        if (relationship.isToMany()) {
            source.addToManyTarget(relationship.getName(), target, false);
        } else {
            source.setToOneTarget(relationship.getName(), target, false);
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        DataObject source = this.findObject(nodeId);
        ObjEntity sourceEntity = this.context.getEntityResolver().lookupObjEntity(source);
        Relationship relationship = sourceEntity.getRelationship(arcId.toString());
        DataObject target = this.findObject(targetNodeId);
        if (relationship.isToMany()) {
            source.removeToManyTarget(relationship.getName(), target, false);
        } else {
            source.setToOneTarget(relationship.getName(), null, false);
        }
    }

    DataObject findObject(Object nodeId) {
        return (DataObject)this.graphManager.getNode(nodeId);
    }
}

