/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.QueryResponse;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataContextFactory;
import org.objectstyle.cayenne.access.DataDomainFlushAction;
import org.objectstyle.cayenne.access.DataDomainLegacyQueryAction;
import org.objectstyle.cayenne.access.DataDomainQueryAction;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.DataRowStore;
import org.objectstyle.cayenne.access.ObjectStore;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryEngine;
import org.objectstyle.cayenne.access.Transaction;
import org.objectstyle.cayenne.access.TransactionDelegate;
import org.objectstyle.cayenne.access.util.PrimaryKeyHelper;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.graph.CompoundDiff;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryChain;
import org.objectstyle.cayenne.util.Util;

public class DataDomain
implements QueryEngine,
DataChannel {
    private static final Logger logObj = Logger.getLogger(DataDomain.class);
    public static final String SHARED_CACHE_ENABLED_PROPERTY = "cayenne.DataDomain.sharedCache";
    public static final boolean SHARED_CACHE_ENABLED_DEFAULT = true;
    public static final String VALIDATING_OBJECTS_ON_COMMIT_PROPERTY = "cayenne.DataDomain.validatingObjectsOnCommit";
    public static final boolean VALIDATING_OBJECTS_ON_COMMIT_DEFAULT = true;
    public static final String USING_EXTERNAL_TRANSACTIONS_PROPERTY = "cayenne.DataDomain.usingExternalTransactions";
    public static final boolean USING_EXTERNAL_TRANSACTIONS_DEFAULT = false;
    public static final String DATA_CONTEXT_FACTORY_PROPERTY = "cayenne.DataDomain.dataContextFactory";
    protected Map nodes = Collections.synchronizedMap(new TreeMap());
    protected Map nodesByDataMapName = Collections.synchronizedMap(new HashMap());
    protected Map properties = Collections.synchronizedMap(new TreeMap());
    protected EntityResolver entityResolver;
    protected DataRowStore sharedSnapshotCache;
    protected TransactionDelegate transactionDelegate;
    protected DataContextFactory dataContextFactory;
    protected String name;
    protected boolean sharedCacheEnabled;
    protected boolean validatingObjectsOnCommit;
    protected boolean usingExternalTransactions;
    protected EventManager eventManager;

    public DataDomain(String name) {
        this.setName(name);
        this.resetProperties();
    }

    public DataDomain(String name, Map properties) {
        this.setName(name);
        this.initWithProperties(properties);
    }

    protected void resetProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.sharedCacheEnabled = true;
        this.validatingObjectsOnCommit = true;
        this.usingExternalTransactions = false;
        this.dataContextFactory = null;
    }

    public void initWithProperties(Map properties) {
        HashMap localMap = new HashMap();
        if (properties != null) {
            localMap.putAll(properties);
        }
        this.properties = localMap;
        Object sharedCacheEnabled = localMap.get(SHARED_CACHE_ENABLED_PROPERTY);
        Object validatingObjectsOnCommit = localMap.get(VALIDATING_OBJECTS_ON_COMMIT_PROPERTY);
        Object usingExternalTransactions = localMap.get(USING_EXTERNAL_TRANSACTIONS_PROPERTY);
        Object dataContextFactory = localMap.get(DATA_CONTEXT_FACTORY_PROPERTY);
        if (logObj.isDebugEnabled()) {
            logObj.debug("DataDomain property cayenne.DataDomain.sharedCache = " + sharedCacheEnabled);
            logObj.debug("DataDomain property cayenne.DataDomain.validatingObjectsOnCommit = " + validatingObjectsOnCommit);
            logObj.debug("DataDomain property cayenne.DataDomain.usingExternalTransactions = " + usingExternalTransactions);
            logObj.debug("DataDomain property cayenne.DataDomain.dataContextFactory = " + dataContextFactory);
        }
        this.sharedCacheEnabled = sharedCacheEnabled != null ? "true".equalsIgnoreCase(sharedCacheEnabled.toString()) : true;
        this.validatingObjectsOnCommit = validatingObjectsOnCommit != null ? "true".equalsIgnoreCase(validatingObjectsOnCommit.toString()) : true;
        boolean bl = this.usingExternalTransactions = usingExternalTransactions != null ? "true".equalsIgnoreCase(usingExternalTransactions.toString()) : false;
        if (dataContextFactory != null && !Util.isEmptyString(dataContextFactory.toString())) {
            try {
                Class<?> factoryClass = Class.forName(dataContextFactory.toString(), true, Thread.currentThread().getContextClassLoader());
                if (!DataContextFactory.class.isAssignableFrom(factoryClass)) {
                    throw new CayenneRuntimeException("Error loading DataContextFactory - factory class does not implement 'DataContextFactory': " + factoryClass.getName());
                }
                this.dataContextFactory = (DataContextFactory)factoryClass.newInstance();
            }
            catch (CayenneRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error loading DataContextFactory: " + dataContextFactory, e);
            }
        } else {
            this.dataContextFactory = null;
        }
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setEventManager(eventManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setName(name);
        }
    }

    public boolean isSharedCacheEnabled() {
        return this.sharedCacheEnabled;
    }

    public void setSharedCacheEnabled(boolean sharedCacheEnabled) {
        this.sharedCacheEnabled = sharedCacheEnabled;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    public boolean isUsingExternalTransactions() {
        return this.usingExternalTransactions;
    }

    public void setUsingExternalTransactions(boolean flag) {
        this.usingExternalTransactions = flag;
    }

    public Map getProperties() {
        return this.properties;
    }

    public TransactionDelegate getTransactionDelegate() {
        return this.transactionDelegate;
    }

    public void setTransactionDelegate(TransactionDelegate transactionDelegate) {
        this.transactionDelegate = transactionDelegate;
    }

    public synchronized DataRowStore getSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null && this.sharedCacheEnabled) {
            this.sharedSnapshotCache = new DataRowStore(this.name, this.properties, this.eventManager);
        }
        return this.sharedSnapshotCache;
    }

    public synchronized void setSharedSnapshotCache(DataRowStore snapshotCache) {
        if (this.sharedSnapshotCache != snapshotCache) {
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
            this.sharedSnapshotCache = snapshotCache;
            if (snapshotCache != null) {
                snapshotCache.setEventManager(this.getEventManager());
                snapshotCache.setName(this.getName());
            }
        }
    }

    public DataContextFactory getDataContextFactory() {
        return this.dataContextFactory;
    }

    public void setDataContextFactory(DataContextFactory dataContextFactory) {
        this.dataContextFactory = dataContextFactory;
    }

    public void addMap(DataMap map) {
        this.getEntityResolver().addDataMap(map);
    }

    public DataMap getMap(String mapName) {
        return this.getEntityResolver().getDataMap(mapName);
    }

    public synchronized void removeMap(String mapName) {
        DataMap map = this.getMap(mapName);
        if (map == null) {
            return;
        }
        Iterator it = this.nodes.values().iterator();
        while (it.hasNext()) {
            DataNode node = (DataNode)it.next();
            node.removeDataMap(mapName);
        }
        this.getEntityResolver().removeDataMap(map);
        this.reindexNodes();
    }

    public synchronized void removeDataNode(String nodeName) {
        DataNode removed = (DataNode)this.nodes.remove(nodeName);
        if (removed != null) {
            removed.setEntityResolver(null);
            Iterator it = this.nodesByDataMapName.values().iterator();
            while (it.hasNext()) {
                if (it.next() != removed) continue;
                it.remove();
            }
        }
    }

    public Collection getDataMaps() {
        return this.getEntityResolver().getDataMaps();
    }

    public Collection getDataNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this.nodes;
        synchronized (map) {
            this.nodes.clear();
            this.nodesByDataMapName.clear();
            if (this.entityResolver != null) {
                this.entityResolver.clearCache();
                this.entityResolver = null;
            }
        }
    }

    public void clearDataMaps() {
        this.getEntityResolver().setDataMaps(Collections.EMPTY_LIST);
    }

    public synchronized void addNode(DataNode node) {
        this.nodes.put(node.getName(), node);
        node.setEntityResolver(this.getEntityResolver());
        Iterator nodeMaps = node.getDataMaps().iterator();
        while (nodeMaps.hasNext()) {
            DataMap map = (DataMap)nodeMaps.next();
            this.addMap(map);
            this.nodesByDataMapName.put(map.getName(), node);
        }
    }

    public DataContext createDataContext() {
        return this.createDataContext(this.isSharedCacheEnabled());
    }

    public DataContext createDataContext(boolean useSharedCache) {
        DataRowStore snapshotCache = useSharedCache ? this.getSharedSnapshotCache() : new DataRowStore(this.name, this.properties, this.eventManager);
        DataContext context = null == this.dataContextFactory ? new DataContext(this, new ObjectStore(snapshotCache)) : this.dataContextFactory.createDataContext(this, new ObjectStore(snapshotCache));
        context.setValidatingObjectsOnCommit(this.isValidatingObjectsOnCommit());
        return context;
    }

    public Transaction createTransaction() {
        return this.isUsingExternalTransactions() ? Transaction.externalTransaction(this.getTransactionDelegate()) : Transaction.internalTransaction(this.getTransactionDelegate());
    }

    public DataNode getNode(String nodeName) {
        return (DataNode)this.nodes.get(nodeName);
    }

    public synchronized void reindexNodes() {
        this.nodesByDataMapName.clear();
        Iterator nodes = this.getDataNodes().iterator();
        while (nodes.hasNext()) {
            DataNode node = (DataNode)nodes.next();
            Iterator nodeMaps = node.getDataMaps().iterator();
            while (nodeMaps.hasNext()) {
                DataMap map = (DataMap)nodeMaps.next();
                this.addMap(map);
                this.nodesByDataMapName.put(map.getName(), node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNode lookupDataNode(DataMap map) {
        Map map2 = this.nodesByDataMapName;
        synchronized (map2) {
            DataNode node = (DataNode)this.nodesByDataMapName.get(map.getName());
            if (node == null) {
                this.reindexNodes();
                return (DataNode)this.nodesByDataMapName.get(map.getName());
            }
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performQueries(Collection queries, OperationObserver callback, Transaction transaction) {
        if (queries.isEmpty()) {
            return;
        }
        Transaction old = Transaction.getThreadTransaction();
        Transaction.bindThreadTransaction(transaction);
        try {
            new DataDomainLegacyQueryAction(this, new QueryChain(queries), callback).execute();
        }
        finally {
            Transaction.bindThreadTransaction(old);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private synchronized void createEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new EntityResolver();
        }
    }

    public synchronized PrimaryKeyHelper getPrimaryKeyHelper() {
        return new PrimaryKeyHelper(this);
    }

    public void shutdown() {
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.shutdown();
        }
        Collection dataNodes = this.getDataNodes();
        Iterator i = dataNodes.iterator();
        while (i.hasNext()) {
            DataNode node = (DataNode)i.next();
            try {
                node.shutdown();
            }
            catch (Exception ex) {}
        }
    }

    public void performQueries(final Collection queries, final OperationObserver callback) {
        this.runInTransaction(new Transformer(){

            public Object transform(Object input) {
                new DataDomainLegacyQueryAction(DataDomain.this, new QueryChain(queries), callback).execute();
                return null;
            }
        });
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new DataDomainQueryAction(context, this, query).execute();
    }

    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.createEntityResolver();
        }
        return this.entityResolver;
    }

    public GraphDiff onSync(final ObjectContext originatingContext, final GraphDiff changes, int syncType) {
        switch (syncType) {
            case 3: {
                return this.onSyncRollback(originatingContext);
            }
            case 1: 
            case 2: {
                return (GraphDiff)this.runInTransaction(new Transformer(){

                    public Object transform(Object input) {
                        return DataDomain.this.onSyncFlush(originatingContext, changes);
                    }
                });
            }
        }
        throw new CayenneRuntimeException("Invalid synchronization type: " + syncType);
    }

    GraphDiff onSyncRollback(ObjectContext originatingContext) {
        Transaction transaction = Transaction.getThreadTransaction();
        if (transaction != null) {
            transaction.setRollbackOnly();
        }
        return new CompoundDiff();
    }

    GraphDiff onSyncFlush(ObjectContext originatingContext, GraphDiff childChanges) {
        if (!(originatingContext instanceof DataContext)) {
            throw new CayenneRuntimeException("No support for committing ObjectContexts that are not DataContexts yet. Unsupported context: " + originatingContext);
        }
        return new DataDomainFlushAction(this).flush((DataContext)originatingContext, childChanges);
    }

    Object runInTransaction(Transformer operation) {
        if (Transaction.getThreadTransaction() != null) {
            return operation.transform(null);
        }
        Transaction transaction = this.createTransaction();
        Transaction.bindThreadTransaction(transaction);
        try {
            Object result = operation.transform(null);
            transaction.commit();
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            transaction.setRollbackOnly();
            if (ex instanceof CayenneRuntimeException) {
                throw (CayenneRuntimeException)ex;
            }
            throw new CayenneRuntimeException(ex);
        }
        finally {
            Transaction.bindThreadTransaction(null);
            if (transaction.getStatus() == 7) {
                try {
                    transaction.rollback();
                }
                catch (Exception rollbackEx) {}
            }
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).toString();
    }
}

