/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryEngine;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.QueryRouter;

public class DataDomainLegacyQueryAction
implements QueryRouter,
OperationObserver {
    static final boolean DONE = true;
    DataDomain domain;
    OperationObserver callback;
    Query query;
    QueryMetadata metadata;
    Map queriesByNode;
    Map queriesByExecutedQueries;

    DataDomainLegacyQueryAction(DataDomain domain, Query query, OperationObserver callback) {
        this.domain = domain;
        this.query = query;
        this.metadata = query.getMetaData(domain.getEntityResolver());
        this.callback = callback;
    }

    final void execute() {
        this.queriesByNode = null;
        this.queriesByExecutedQueries = null;
        this.query.route(this, this.domain.getEntityResolver(), null);
        if (this.queriesByNode != null) {
            Iterator nodeIt = this.queriesByNode.entrySet().iterator();
            while (nodeIt.hasNext()) {
                Map.Entry entry = nodeIt.next();
                QueryEngine nextNode = (QueryEngine)entry.getKey();
                Collection nodeQueries = (Collection)entry.getValue();
                nextNode.performQueries(nodeQueries, this);
            }
        }
    }

    public void route(QueryEngine engine, Query query, Query substitutedQuery) {
        ArrayList<Query> queries = null;
        if (this.queriesByNode == null) {
            this.queriesByNode = new HashMap();
        } else {
            queries = (ArrayList<Query>)this.queriesByNode.get(engine);
        }
        if (queries == null) {
            queries = new ArrayList<Query>(5);
            this.queriesByNode.put(engine, queries);
        }
        queries.add(query);
        if (substitutedQuery != null && substitutedQuery != query) {
            if (this.queriesByExecutedQueries == null) {
                this.queriesByExecutedQueries = new HashMap();
            }
            this.queriesByExecutedQueries.put(query, substitutedQuery);
        }
    }

    public QueryEngine engineForDataMap(DataMap map) {
        if (map == null) {
            throw new NullPointerException("Null DataMap, can't determine DataNode.");
        }
        DataNode node = this.domain.lookupDataNode(map);
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode exists for DataMap " + map);
        }
        return node;
    }

    public void nextCount(Query query, int resultCount) {
        this.callback.nextCount(this.queryForExecutedQuery(query), resultCount);
    }

    public void nextBatchCount(Query query, int[] resultCount) {
        this.callback.nextBatchCount(this.queryForExecutedQuery(query), resultCount);
    }

    public void nextDataRows(Query query, List dataRows) {
        this.callback.nextDataRows(this.queryForExecutedQuery(query), dataRows);
    }

    public void nextDataRows(Query q, ResultIterator it) {
        this.callback.nextDataRows(this.queryForExecutedQuery(q), it);
    }

    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        this.callback.nextGeneratedDataRows(this.queryForExecutedQuery(query), keysIterator);
    }

    public void nextQueryException(Query query, Exception ex) {
        this.callback.nextQueryException(this.queryForExecutedQuery(query), ex);
    }

    public void nextGlobalException(Exception e) {
        this.callback.nextGlobalException(e);
    }

    public Level getLoggingLevel() {
        return this.callback.getLoggingLevel();
    }

    public boolean isIteratedResult() {
        return this.callback.isIteratedResult();
    }

    Query queryForExecutedQuery(Query executedQuery) {
        Query q = null;
        if (this.queriesByExecutedQueries != null) {
            q = (Query)this.queriesByExecutedQueries.get(executedQuery);
        }
        return q != null ? q : executedQuery;
    }
}

