/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Level;
import org.objectstyle.cayenne.CayenneException;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.QueryResponse;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.DataRowStore;
import org.objectstyle.cayenne.access.ObjectResolver;
import org.objectstyle.cayenne.access.ObjectTreeResolver;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.access.QueryEngine;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.ResultIterator;
import org.objectstyle.cayenne.map.DataMap;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.query.ObjectIdQuery;
import org.objectstyle.cayenne.query.PrefetchSelectQuery;
import org.objectstyle.cayenne.query.PrefetchTreeNode;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.QueryRouter;
import org.objectstyle.cayenne.query.RelationshipQuery;
import org.objectstyle.cayenne.util.GenericResponse;
import org.objectstyle.cayenne.util.ListResponse;
import org.objectstyle.cayenne.util.Util;

class DataDomainQueryAction
implements QueryRouter,
OperationObserver {
    static final boolean DONE = true;
    DataContext context;
    DataDomain domain;
    DataRowStore cache;
    Query query;
    QueryMetadata metadata;
    QueryResponse response;
    GenericResponse fullResponse;
    Map prefetchResultsByPath;
    Map queriesByNode;
    Map queriesByExecutedQueries;

    DataDomainQueryAction(ObjectContext context, DataDomain domain, Query query) {
        if (context != null && !(context instanceof DataContext)) {
            throw new IllegalArgumentException("DataDomain can only work with DataContext. Unsupported context type: " + context);
        }
        this.domain = domain;
        this.query = query;
        this.metadata = query.getMetaData(domain.getEntityResolver());
        this.context = (DataContext)context;
        this.cache = this.context != null ? this.context.getObjectStore().getDataRowCache() : domain.getSharedSnapshotCache();
    }

    QueryResponse execute() {
        if (!(this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptSharedCache())) {
            this.runQueryInTransaction();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    private boolean interceptOIDQuery() {
        if (this.query instanceof ObjectIdQuery) {
            ObjectIdQuery oidQuery = (ObjectIdQuery)this.query;
            DataRow row = null;
            if (!oidQuery.isFetchMandatory()) {
                row = this.cache.getCachedSnapshot(oidQuery.getObjectId());
            }
            if (row == null) {
                if (oidQuery.isFetchAllowed()) {
                    this.runQueryInTransaction();
                    List result = this.response.firstList();
                    if (result != null && !result.isEmpty()) {
                        if (result.size() > 1) {
                            throw new CayenneRuntimeException("More than 1 row found for ObjectId " + oidQuery.getObjectId() + ". Fetch matched " + result.size() + " rows.");
                        }
                        this.cache.snapshots.put(oidQuery.getObjectId(), result.get(0));
                    }
                } else {
                    this.response = new ListResponse();
                }
            } else {
                this.response = new ListResponse(row);
            }
            return true;
        }
        return false;
    }

    private boolean interceptRelationshipQuery() {
        if (this.query instanceof RelationshipQuery) {
            DataRow resultRow;
            RelationshipQuery relationshipQuery = (RelationshipQuery)this.query;
            if (relationshipQuery.isRefreshing()) {
                return false;
            }
            ObjRelationship relationship = relationshipQuery.getRelationship(this.domain.getEntityResolver());
            if (relationship.isSourceIndependentFromTargetChange()) {
                return false;
            }
            DataRow sourceRow = this.cache.getCachedSnapshot(relationshipQuery.getObjectId());
            if (sourceRow == null) {
                return false;
            }
            DbRelationship dbRelationship = (DbRelationship)relationship.getDbRelationships().get(0);
            ObjectId targetId = sourceRow.createTargetObjectId(relationship.getTargetEntityName(), dbRelationship);
            if (targetId == null) {
                this.response = new GenericResponse(Collections.EMPTY_LIST);
                return true;
            }
            DataRow targetRow = this.cache.getCachedSnapshot(targetId);
            if (targetRow != null) {
                resultRow = targetRow;
            } else if (this.domain.getEntityResolver().lookupInheritanceTree((ObjEntity)relationship.getTargetEntity()) == null) {
                resultRow = new DataRow(targetId.getIdSnapshot());
            } else {
                return false;
            }
            this.response = new GenericResponse(Collections.singletonList(resultRow));
            return true;
        }
        return false;
    }

    private final boolean interceptSharedCache() {
        List cachedRows;
        boolean cacheOrCacheRefresh;
        String cacheKey = this.metadata.getCacheKey();
        if (cacheKey == null) {
            return false;
        }
        boolean cache = "sharedcache".equals(this.metadata.getCachePolicy());
        boolean bl = cacheOrCacheRefresh = cache || "sharedcache_refresh".equals(this.metadata.getCachePolicy());
        if (!cacheOrCacheRefresh) {
            return false;
        }
        if (cache && (cachedRows = this.cache.getCachedSnapshots(cacheKey)) != null) {
            this.response = new ListResponse(Collections.unmodifiableList(cachedRows));
            return true;
        }
        this.runQueryInTransaction();
        List list = this.response.firstList();
        if (list != null) {
            this.cache.cacheSnapshots(cacheKey, list);
        }
        return true;
    }

    void runQueryInTransaction() {
        this.domain.runInTransaction(new Transformer(){

            public Object transform(Object input) {
                DataDomainQueryAction.this.runQuery();
                return null;
            }
        });
    }

    private void runQuery() {
        this.fullResponse = new GenericResponse();
        this.response = this.fullResponse;
        this.queriesByNode = null;
        this.queriesByExecutedQueries = null;
        this.prefetchResultsByPath = this.metadata.getPrefetchTree() != null && !this.metadata.isFetchingDataRows() ? new HashMap() : null;
        this.query.route(this, this.domain.getEntityResolver(), null);
        if (this.queriesByNode != null) {
            Iterator nodeIt = this.queriesByNode.entrySet().iterator();
            while (nodeIt.hasNext()) {
                Map.Entry entry = nodeIt.next();
                QueryEngine nextNode = (QueryEngine)entry.getKey();
                Collection nodeQueries = (Collection)entry.getValue();
                nextNode.performQueries(nodeQueries, this);
            }
        }
    }

    private void interceptObjectConversion() {
        List mainRows;
        if (this.context != null && !this.metadata.isFetchingDataRows() && (mainRows = this.response.firstList()) != null && !mainRows.isEmpty()) {
            List objects;
            ObjEntity entity = this.metadata.getObjEntity();
            PrefetchTreeNode prefetchTree = this.metadata.getPrefetchTree();
            if (prefetchTree == null) {
                objects = new ObjectResolver(this.context, entity, this.metadata.isRefreshingObjects(), this.metadata.isResolvingInherited()).synchronizedObjectsFromDataRows(mainRows);
            } else {
                ObjectTreeResolver resolver = new ObjectTreeResolver(this.context, this.metadata);
                objects = resolver.resolveObjectTree(prefetchTree, mainRows, this.prefetchResultsByPath);
            }
            if (this.response instanceof GenericResponse) {
                ((GenericResponse)this.response).replaceResult(mainRows, objects);
            } else if (this.response instanceof ListResponse) {
                this.response = new ListResponse(objects);
            } else {
                throw new IllegalStateException("Unknown response object: " + this.response);
            }
        }
    }

    public void route(QueryEngine engine, Query query, Query substitutedQuery) {
        ArrayList<Query> queries = null;
        if (this.queriesByNode == null) {
            this.queriesByNode = new HashMap();
        } else {
            queries = (ArrayList<Query>)this.queriesByNode.get(engine);
        }
        if (queries == null) {
            queries = new ArrayList<Query>(5);
            this.queriesByNode.put(engine, queries);
        }
        queries.add(query);
        if (substitutedQuery != null && substitutedQuery != query) {
            if (this.queriesByExecutedQueries == null) {
                this.queriesByExecutedQueries = new HashMap();
            }
            this.queriesByExecutedQueries.put(query, substitutedQuery);
        }
    }

    public QueryEngine engineForDataMap(DataMap map) {
        if (map == null) {
            throw new NullPointerException("Null DataMap, can't determine DataNode.");
        }
        DataNode node = this.domain.lookupDataNode(map);
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode exists for DataMap " + map);
        }
        return node;
    }

    public void nextCount(Query query, int resultCount) {
        this.fullResponse.addUpdateCount(resultCount);
    }

    public void nextBatchCount(Query query, int[] resultCount) {
        this.fullResponse.addBatchUpdateCount(resultCount);
    }

    public void nextDataRows(Query query, List dataRows) {
        if (this.prefetchResultsByPath != null && query instanceof PrefetchSelectQuery) {
            PrefetchSelectQuery prefetchQuery = (PrefetchSelectQuery)query;
            this.prefetchResultsByPath.put(prefetchQuery.getPrefetchPath(), dataRows);
        } else {
            this.fullResponse.addResultList(dataRows);
        }
    }

    public void nextDataRows(Query q, ResultIterator it) {
        throw new CayenneRuntimeException("Invalid attempt to fetch a cursor.");
    }

    public void nextGeneratedDataRows(Query query, ResultIterator keysIterator) {
        if (keysIterator != null) {
            try {
                this.nextDataRows(query, keysIterator.dataRows(true));
            }
            catch (CayenneException ex) {
                this.nextQueryException(query, ex);
            }
        }
    }

    public void nextQueryException(Query query, Exception ex) {
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex));
    }

    public void nextGlobalException(Exception e) {
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(e));
    }

    public Level getLoggingLevel() {
        return QueryLogger.DEFAULT_LOG_LEVEL;
    }

    public boolean isIteratedResult() {
        return false;
    }
}

