/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataNodeSyncBucket;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.map.Attribute;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;

class DataNodeDBDiffBuilder
implements GraphChangeHandler {
    private final boolean supportsGeneratedKeys;
    private ObjEntity objEntity;
    private DbEntity dbEntity;
    private Map currentPropertyDiff;
    private Map currentArcDiff;
    private Object currentId;

    DataNodeDBDiffBuilder(boolean supportsGeneratedKeys) {
        this.supportsGeneratedKeys = supportsGeneratedKeys;
    }

    void reset(ObjEntity objEntity, DbEntity dbEntity) {
        this.objEntity = objEntity;
        this.dbEntity = dbEntity;
    }

    private void reset() {
        this.currentPropertyDiff = null;
        this.currentArcDiff = null;
        this.currentId = null;
    }

    Map buildDBDiff(GraphDiff singleObjectDiff) {
        this.reset();
        singleObjectDiff.apply(this);
        if (this.currentPropertyDiff == null && this.currentArcDiff == null && this.currentId == null) {
            return null;
        }
        HashMap dbDiff = new HashMap();
        this.appendSimpleProperties(dbDiff);
        this.appendForeignKeys(dbDiff);
        this.appendPrimaryKeys(dbDiff);
        return dbDiff.isEmpty() ? null : dbDiff;
    }

    private void appendSimpleProperties(Map dbDiff) {
        if (this.currentPropertyDiff != null) {
            Iterator it = this.currentPropertyDiff.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjAttribute attribute = (ObjAttribute)this.objEntity.getAttribute(entry.getKey().toString());
                Attribute dbAttribute = this.dbEntity.getAttribute(attribute.getDbAttributeName());
                dbDiff.put(dbAttribute.getName(), entry.getValue());
            }
        }
    }

    private void appendForeignKeys(Map dbDiff) {
        if (this.currentArcDiff != null) {
            Iterator it = this.currentArcDiff.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjRelationship relation = (ObjRelationship)this.objEntity.getRelationship(entry.getKey().toString());
                DbRelationship dbRelation = (DbRelationship)relation.getDbRelationships().get(0);
                Map targetKeys = null;
                ObjectId targetId = (ObjectId)entry.getValue();
                if (targetId != null) {
                    targetKeys = targetId.getIdSnapshot();
                }
                Iterator joins = dbRelation.getJoins().iterator();
                while (joins.hasNext()) {
                    DataNodeSyncBucket.PropagatedValueFactory value;
                    DbJoin join = (DbJoin)joins.next();
                    if (targetKeys != null) {
                        DbAttribute targetAttribute;
                        value = (DataNodeSyncBucket.PropagatedValueFactory)targetKeys.get(join.getTargetName());
                        if (value == null && this.supportsGeneratedKeys && (targetAttribute = join.getTarget()).isGenerated()) {
                            value = new DataNodeSyncBucket.PropagatedValueFactory(targetId, join.getTargetName());
                        }
                    } else {
                        value = null;
                    }
                    dbDiff.put(join.getSourceName(), value);
                }
            }
        }
    }

    private void appendPrimaryKeys(Map dbDiff) {
        if (this.currentId != null) {
            Iterator it = ((ObjectId)this.currentId).getIdSnapshot().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (dbDiff.containsKey(entry.getKey())) continue;
                dbDiff.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        if (this.currentPropertyDiff == null) {
            this.currentPropertyDiff = new HashMap();
        }
        this.currentPropertyDiff.put(property, newValue);
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjRelationship relationship = (ObjRelationship)this.objEntity.getRelationship(arcId.toString());
        if (!relationship.isSourceIndependentFromTargetChange()) {
            if (this.currentArcDiff == null) {
                this.currentArcDiff = new HashMap();
            }
            this.currentArcDiff.put(arcId, targetNodeId);
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjRelationship relationship = (ObjRelationship)this.objEntity.getRelationship(arcId.toString());
        if (!relationship.isSourceIndependentFromTargetChange()) {
            if (this.currentArcDiff == null) {
                this.currentArcDiff = new HashMap();
                this.currentArcDiff.put(arcId, null);
            } else if (targetNodeId.equals(this.currentArcDiff.get(arcId))) {
                this.currentArcDiff.put(arcId, null);
            }
        }
    }

    public void nodeCreated(Object nodeId) {
        this.currentId = nodeId;
    }

    public void nodeRemoved(Object nodeId) {
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }
}

