/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.access.DataNodeFlushAction;
import org.objectstyle.cayenne.access.DataNodeSyncBucket;
import org.objectstyle.cayenne.access.DataNodeSyncQualifierDescriptor;
import org.objectstyle.cayenne.access.ObjectDiff;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntitySorter;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.DeleteBatchQuery;

class DataNodeDeleteBucket
extends DataNodeSyncBucket {
    DataNodeDeleteBucket(DataNodeFlushAction parent) {
        super(parent);
    }

    void postprocess() {
        if (!this.objectsByEntity.isEmpty()) {
            Collection deletedIds = this.parent.getParent().getResultDeletedIds();
            Iterator it = this.objectsByEntity.values().iterator();
            while (it.hasNext()) {
                Iterator objects = ((Collection)it.next()).iterator();
                while (objects.hasNext()) {
                    Persistent object = (Persistent)objects.next();
                    deletedIds.add(object.getObjectId());
                }
            }
        }
    }

    void appendQueriesInternal(Collection queries) {
        DataNodeSyncQualifierDescriptor qualifierBuilder = new DataNodeSyncQualifierDescriptor();
        EntitySorter sorter = this.parent.getNode().getEntitySorter();
        sorter.sortDbEntities(this.dbEntities, true);
        Iterator i = this.dbEntities.iterator();
        while (i.hasNext()) {
            DbEntity dbEntity = (DbEntity)i.next();
            List objEntitiesForDbEntity = (List)this.objEntitiesByDbEntity.get(dbEntity);
            LinkedMap batches = new LinkedMap();
            Iterator j = objEntitiesForDbEntity.iterator();
            while (j.hasNext()) {
                ObjEntity entity = (ObjEntity)j.next();
                qualifierBuilder.reset(entity, dbEntity);
                boolean isRootDbEntity = entity.getDbEntity() == dbEntity;
                List objects = (List)this.objectsByEntity.get(entity);
                if (objects.isEmpty()) continue;
                this.checkReadOnly(entity);
                if (isRootDbEntity) {
                    sorter.sortObjectsForEntity(entity, objects, true);
                }
                Iterator k = objects.iterator();
                while (k.hasNext()) {
                    DataObject o = (DataObject)k.next();
                    ObjectDiff diff = this.parent.objectDiff(o.getObjectId());
                    Map qualifierSnapshot = qualifierBuilder.createQualifierSnapshot(diff);
                    HashSet nullQualifierNames = new HashSet();
                    Iterator it = qualifierSnapshot.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (entry.getValue() != null) continue;
                        nullQualifierNames.add(entry.getKey());
                    }
                    List<Object> batchKey = Arrays.asList(nullQualifierNames);
                    DeleteBatchQuery batch = (DeleteBatchQuery)batches.get(batchKey);
                    if (batch == null) {
                        batch = new DeleteBatchQuery(dbEntity, qualifierBuilder.getAttributes(), nullQualifierNames, 27);
                        batch.setUsingOptimisticLocking(qualifierBuilder.isUsingOptimisticLocking());
                        batches.put(batchKey, batch);
                    }
                    batch.add(qualifierSnapshot);
                }
            }
            queries.addAll(batches.values());
        }
    }
}

