/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.access.DataDomainFlushAction;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.DataNodeDeleteBucket;
import org.objectstyle.cayenne.access.DataNodeFlattenedBucket;
import org.objectstyle.cayenne.access.DataNodeInsertBucket;
import org.objectstyle.cayenne.access.DataNodeUpdateBucket;
import org.objectstyle.cayenne.access.FlattenedArcKey;
import org.objectstyle.cayenne.access.ObjectDiff;
import org.objectstyle.cayenne.access.OperationObserver;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.ObjEntity;

class DataNodeFlushAction {
    final DataDomainFlushAction parent;
    final DataNode node;
    private final DataNodeInsertBucket insertBucket;
    private final DataNodeUpdateBucket updateBucket;
    private final DataNodeDeleteBucket deleteBucket;
    private final DataNodeFlattenedBucket flattenedBucket;
    private final Collection queries;

    DataNodeFlushAction(DataDomainFlushAction parent, DataNode node) {
        this.node = node;
        this.parent = parent;
        this.insertBucket = new DataNodeInsertBucket(this);
        this.deleteBucket = new DataNodeDeleteBucket(this);
        this.updateBucket = new DataNodeUpdateBucket(this);
        this.flattenedBucket = new DataNodeFlattenedBucket(this);
        this.queries = new ArrayList();
    }

    DataDomainFlushAction getParent() {
        return this.parent;
    }

    DataNode getNode() {
        return this.node;
    }

    void createPK() {
        this.insertBucket.createPrimaryKey();
    }

    void createQueries() {
        this.insertBucket.appendQueries(this.queries);
        this.flattenedBucket.appendInserts(this.queries);
        this.updateBucket.appendQueries(this.queries);
        this.flattenedBucket.appendDeletes(this.queries);
        this.deleteBucket.appendQueries(this.queries);
    }

    void flush(OperationObserver observer) {
        this.node.performQueries(this.queries, observer);
    }

    void postprocess() {
        this.deleteBucket.postprocess();
        this.updateBucket.postprocess();
        this.insertBucket.postprocess();
    }

    ObjectDiff objectDiff(Object objectId) {
        return (ObjectDiff)this.parent.getChangesByObjectId().get(objectId);
    }

    void addFlattenedInsert(DbEntity flattenedEntity, FlattenedArcKey flattenedInsertInfo) {
        this.flattenedBucket.addFlattenedInsert(flattenedEntity, flattenedInsertInfo);
    }

    void addFlattenedDelete(DbEntity flattenedEntity, FlattenedArcKey flattenedDeleteInfo) {
        this.flattenedBucket.addFlattenedDelete(flattenedEntity, flattenedDeleteInfo);
    }

    void addDirtyObject(Persistent object, ObjEntity entity) {
        switch (object.getPersistenceState()) {
            case 2: {
                this.insertBucket.addDirtyObject(object, entity);
                break;
            }
            case 4: {
                this.updateBucket.addDirtyObject(object, entity);
                break;
            }
            case 6: {
                this.deleteBucket.addDirtyObject(object, entity);
            }
        }
    }

    boolean isNoop() {
        return this.queries.isEmpty();
    }
}

