/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.DataDomainFlushAction;
import org.objectstyle.cayenne.access.DataNodeFlushAction;
import org.objectstyle.cayenne.access.FlattenedArcKey;
import org.objectstyle.cayenne.graph.GraphChangeHandler;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;

final class DataNodeIndirectDiffBuilder
implements GraphChangeHandler {
    private final DataDomainFlushAction parent;
    private final EntityResolver resolver;
    private final Collection indirectModifications;
    private final Collection flattenedInserts;
    private final Collection flattenedDeletes;

    DataNodeIndirectDiffBuilder(DataDomainFlushAction parent) {
        this.parent = parent;
        this.indirectModifications = parent.getResultIndirectlyModifiedIds();
        this.resolver = parent.getDomain().getEntityResolver();
        this.flattenedInserts = new HashSet();
        this.flattenedDeletes = new HashSet();
    }

    void processIndirectChanges(GraphDiff allChanges) {
        DataNodeFlushAction action;
        DbEntity entity;
        FlattenedArcKey key;
        Iterator it;
        allChanges.apply(this);
        if (!this.flattenedInserts.isEmpty()) {
            it = this.flattenedInserts.iterator();
            while (it.hasNext()) {
                key = (FlattenedArcKey)it.next();
                entity = key.getJoinEntity();
                action = this.parent.getNodeAction(entity);
                action.addFlattenedInsert(entity, key);
            }
        }
        if (!this.flattenedDeletes.isEmpty()) {
            it = this.flattenedDeletes.iterator();
            while (it.hasNext()) {
                key = (FlattenedArcKey)it.next();
                entity = key.getJoinEntity();
                action = this.parent.getNodeAction(entity);
                action.addFlattenedDelete(entity, key);
            }
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, Object arcId) {
        ObjEntity entity = this.resolver.getObjEntity(((ObjectId)nodeId).getEntityName());
        ObjRelationship relationship = (ObjRelationship)entity.getRelationship(arcId.toString());
        if (relationship.isSourceIndependentFromTargetChange()) {
            if (!((ObjectId)nodeId).isTemporary()) {
                this.indirectModifications.add(nodeId);
            }
            if (relationship.isFlattened()) {
                if (relationship.isReadOnly()) {
                    throw new CayenneRuntimeException("Cannot set the read-only flattened relationship " + relationship.getName());
                }
                FlattenedArcKey key = new FlattenedArcKey((ObjectId)nodeId, (ObjectId)targetNodeId, relationship);
                if (!this.flattenedDeletes.remove(key)) {
                    this.flattenedInserts.add(key);
                }
            }
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, Object arcId) {
        ObjEntity entity = this.resolver.getObjEntity(((ObjectId)nodeId).getEntityName());
        ObjRelationship relationship = (ObjRelationship)entity.getRelationship(arcId.toString());
        if (relationship.isSourceIndependentFromTargetChange()) {
            if (!((ObjectId)nodeId).isTemporary()) {
                this.indirectModifications.add(nodeId);
            }
            if (relationship.isFlattened()) {
                if (relationship.isReadOnly()) {
                    throw new CayenneRuntimeException("Cannot unset the read-only flattened relationship " + relationship.getName());
                }
                FlattenedArcKey key = new FlattenedArcKey((ObjectId)nodeId, (ObjectId)targetNodeId, relationship);
                if (!this.flattenedInserts.remove(key)) {
                    this.flattenedDeletes.add(key);
                }
            }
        }
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    public void nodeCreated(Object nodeId) {
    }

    public void nodeRemoved(Object nodeId) {
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
    }
}

