/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.DataRow;
import org.objectstyle.cayenne.Fault;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.ValueHolder;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.access.ObjectDiff;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.util.Util;

class DataRowUtils {
    static void mergeObjectWithSnapshot(ObjEntity entity, DataObject object, DataRow snapshot) {
        int state = object.getPersistenceState();
        if (entity.isReadOnly() || state == 5) {
            DataRowUtils.refreshObjectWithSnapshot(entity, object, snapshot, true);
        } else if (state != 3 || object.getDataContext().getChannel() instanceof ObjectContext) {
            DataRowUtils.forceMergeWithSnapshot(entity, object, snapshot);
        } else {
            DataRowUtils.refreshObjectWithSnapshot(entity, object, snapshot, false);
        }
    }

    static void refreshObjectWithSnapshot(ObjEntity objEntity, DataObject object, DataRow snapshot, boolean invalidateToManyRelationships) {
        SortedMap attrMap = objEntity.getAttributeMap();
        Iterator it = attrMap.entrySet().iterator();
        boolean isPartialSnapshot = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String attrName = (String)entry.getKey();
            ObjAttribute attr = (ObjAttribute)entry.getValue();
            String dbAttrPath = attr.getDbAttributePath();
            object.writePropertyDirectly(attrName, snapshot.get(dbAttrPath));
            if (snapshot.containsKey(dbAttrPath)) continue;
            isPartialSnapshot = true;
        }
        Iterator rit = objEntity.getRelationships().iterator();
        while (rit.hasNext()) {
            ObjRelationship rel = (ObjRelationship)rit.next();
            if (rel.isToMany()) {
                Object toManyList = object.readPropertyDirectly(rel.getName());
                if (toManyList == null) {
                    object.writePropertyDirectly(rel.getName(), Fault.getToManyFault());
                    continue;
                }
                if (!invalidateToManyRelationships || !(toManyList instanceof ValueHolder)) continue;
                ((ValueHolder)toManyList).invalidate();
                continue;
            }
            object.writePropertyDirectly(rel.getName(), Fault.getToOneFault());
        }
        if (isPartialSnapshot) {
            object.setPersistenceState(5);
        } else {
            object.setPersistenceState(3);
        }
    }

    static void forceMergeWithSnapshot(ObjEntity entity, DataObject object, DataRow snapshot) {
        DataContext context = object.getDataContext();
        ObjectDiff diff = (ObjectDiff)context.getObjectStore().getChangesByObjectId().get(object.getObjectId());
        SortedMap attrMap = entity.getAttributeMap();
        Iterator it = attrMap.entrySet().iterator();
        while (it.hasNext()) {
            Object oldVal;
            Map.Entry entry = it.next();
            String attrName = (String)entry.getKey();
            ObjAttribute attr = (ObjAttribute)entry.getValue();
            String dbAttrPath = attr.getDbAttributePath();
            Object newVal = snapshot.get(dbAttrPath);
            if (newVal == null && !snapshot.containsKey(dbAttrPath)) continue;
            Object curVal = object.readPropertyDirectly(attrName);
            if (!Util.nullSafeEquals(curVal, oldVal = diff != null ? diff.getSnapshotValue(attrName) : null) || Util.nullSafeEquals(newVal, curVal)) continue;
            object.writePropertyDirectly(attrName, newVal);
        }
        Iterator rit = entity.getRelationships().iterator();
        while (rit.hasNext()) {
            ObjRelationship rel = (ObjRelationship)rit.next();
            if (rel.isToMany() || DataRowUtils.isToOneTargetModified(rel, object, diff)) continue;
            DbRelationship dbRelationship = (DbRelationship)rel.getDbRelationships().get(0);
            ObjectId id = snapshot.createTargetObjectId(rel.getTargetEntityName(), dbRelationship);
            if (diff != null && diff.containsArcSnapshot(rel.getName()) && Util.nullSafeEquals(id, diff.getArcSnapshotValue(rel.getName()))) continue;
            Persistent target = id != null ? context.localObject(id, null) : null;
            object.writeProperty(rel.getName(), target);
        }
    }

    static boolean isToOneTargetModified(ObjRelationship relationship, DataObject object, ObjectDiff diff) {
        ObjectId currentId;
        if (object.getPersistenceState() != 4 || diff == null) {
            return false;
        }
        Object targetObject = object.readPropertyDirectly(relationship.getName());
        if (targetObject instanceof Fault) {
            return false;
        }
        DataObject toOneTarget = (DataObject)targetObject;
        ObjectId objectId = currentId = toOneTarget != null ? toOneTarget.getObjectId() : null;
        if (currentId != null && currentId.isTemporary()) {
            return true;
        }
        if (!diff.containsArcSnapshot(relationship.getName())) {
            return false;
        }
        ObjectId targetId = diff.getArcSnapshotValue(relationship.getName());
        return !Util.nullSafeEquals(currentId, targetId);
    }

    DataRowUtils() {
    }
}

