/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.event;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.objectstyle.cayenne.event.CayenneEvent;

public class SnapshotEvent
extends CayenneEvent {
    protected long timestamp = System.currentTimeMillis();
    protected Collection deletedIds;
    protected Collection invalidatedIds;
    protected Map modifiedDiffs;
    protected Collection indirectlyModifiedIds;

    public SnapshotEvent(Object source, Object postedBy, Map modifiedDiffs, Collection deletedIds, Collection indirectlyModifiedIds) {
        this(source, postedBy, modifiedDiffs, deletedIds, Collections.EMPTY_LIST, indirectlyModifiedIds);
    }

    public SnapshotEvent(Object source, Object postedBy, Map modifiedDiffs, Collection deletedIds, Collection invalidatedIds, Collection indirectlyModifiedIds) {
        super(source, postedBy, null);
        this.modifiedDiffs = modifiedDiffs;
        this.deletedIds = deletedIds;
        this.invalidatedIds = invalidatedIds;
        this.indirectlyModifiedIds = indirectlyModifiedIds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map getModifiedDiffs() {
        return this.modifiedDiffs != null ? this.modifiedDiffs : Collections.EMPTY_MAP;
    }

    public Collection getDeletedIds() {
        return this.deletedIds != null ? this.deletedIds : Collections.EMPTY_LIST;
    }

    public Collection getInvalidatedIds() {
        return this.invalidatedIds != null ? this.invalidatedIds : Collections.EMPTY_LIST;
    }

    public Collection getIndirectlyModifiedIds() {
        return this.indirectlyModifiedIds != null ? this.indirectlyModifiedIds : Collections.EMPTY_LIST;
    }

    public String toString() {
        Collection related;
        Collection invalidated;
        Collection deleted;
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SnapshotEvent] source: ").append(this.getSource());
        Map modified = this.getModifiedDiffs();
        if (!modified.isEmpty()) {
            buffer.append(", modified ").append(modified.size()).append(" id(s)");
        }
        if (!(deleted = this.getDeletedIds()).isEmpty()) {
            buffer.append(", deleted ").append(deleted.size()).append(" id(s)");
        }
        if (!(invalidated = this.getInvalidatedIds()).isEmpty()) {
            buffer.append(", invalidated ").append(invalidated.size()).append(" id(s)");
        }
        if (!(related = this.getIndirectlyModifiedIds()).isEmpty()) {
            buffer.append(", indirectly modified ").append(related.size()).append(" id(s)");
        }
        return buffer.toString();
    }
}

