/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.access.trans;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.access.trans.DataObjectMatchTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.trans.QueryAssemblerHelper;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.TraversalHandler;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.map.EntityInheritanceTree;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.query.QualifiedQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SelectQuery;

public class QualifierTranslator
extends QueryAssemblerHelper
implements TraversalHandler {
    protected StringBuffer qualBuf = new StringBuffer();
    protected boolean translateParentQual;
    protected DataObjectMatchTranslator objectMatchTranslator;
    protected boolean matchingObject;

    public QualifierTranslator() {
        this(null);
    }

    public QualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    public String doTranslation() {
        this.qualBuf.setLength(0);
        Expression rootNode = this.extractQualifier();
        if (rootNode == null) {
            return null;
        }
        rootNode.traverse(this);
        return this.qualBuf.length() > 0 ? this.qualBuf.toString() : null;
    }

    protected Expression extractQualifier() {
        Query q = this.queryAssembler.getQuery();
        Expression qualifier = this.isTranslateParentQual() ? ((SelectQuery)q).getParentQualifier() : ((QualifiedQuery)q).getQualifier();
        ObjEntity entity = this.getObjEntity();
        if (entity != null) {
            Expression entityQualifier;
            EntityInheritanceTree tree = this.queryAssembler.getEntityResolver().lookupInheritanceTree(entity);
            Expression expression = entityQualifier = tree != null ? tree.qualifierForEntityAndSubclasses() : entity.getDeclaredQualifier();
            if (entityQualifier != null) {
                qualifier = qualifier != null ? qualifier.andExp(entityQualifier) : entityQualifier;
            }
        }
        return qualifier;
    }

    protected void detectObjectMatch(Expression exp) {
        this.matchingObject = false;
        if (exp.getOperandCount() != 2) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            Object op = exp.getOperand(i);
            if (!(op instanceof DataObject) && !(op instanceof ObjectId)) continue;
            this.matchingObject = true;
            if (this.objectMatchTranslator == null) {
                this.objectMatchTranslator = new DataObjectMatchTranslator();
                break;
            }
            this.objectMatchTranslator.reset();
            break;
        }
    }

    protected void appendObjectMatch() {
        if (!this.matchingObject || this.objectMatchTranslator == null) {
            throw new IllegalStateException("An invalid attempt to append object match.");
        }
        this.matchingObject = false;
        boolean first = true;
        DbRelationship relationship = this.objectMatchTranslator.getRelationship();
        if (!relationship.isToMany() && !relationship.isToPK()) {
            this.queryAssembler.dbRelationshipAdded(relationship);
        }
        Iterator it = this.objectMatchTranslator.keys();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.qualBuf.append(" AND ");
            }
            String key = (String)it.next();
            DbAttribute attr = this.objectMatchTranslator.getAttribute(key);
            Object val = this.objectMatchTranslator.getValue(key);
            this.processColumn(this.qualBuf, attr, relationship);
            this.qualBuf.append(this.objectMatchTranslator.getOperation());
            this.appendLiteral(this.qualBuf, val, attr, this.objectMatchTranslator.getExpression());
        }
        this.objectMatchTranslator.reset();
    }

    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        StringBuffer buf = this.matchingObject ? new StringBuffer() : this.qualBuf;
        switch (node.getType()) {
            case 0: {
                buf.append(" AND ");
                break;
            }
            case 1: {
                buf.append(" OR ");
                break;
            }
            case 3: {
                if (childIndex == 0 && node.getOperandCount() == 2 && node.getOperand(1) == null) {
                    buf.append(" IS ");
                    break;
                }
                buf.append(" = ");
                break;
            }
            case 4: {
                if (childIndex == 0 && node.getOperandCount() == 2 && node.getOperand(1) == null) {
                    buf.append(" IS NOT ");
                    break;
                }
                buf.append(" <> ");
                break;
            }
            case 5: {
                buf.append(" < ");
                break;
            }
            case 6: {
                buf.append(" > ");
                break;
            }
            case 7: {
                buf.append(" <= ");
                break;
            }
            case 8: {
                buf.append(" >= ");
                break;
            }
            case 10: {
                buf.append(" IN ");
                break;
            }
            case 36: {
                buf.append(" NOT IN ");
                break;
            }
            case 11: {
                buf.append(" LIKE ");
                break;
            }
            case 37: {
                buf.append(" NOT LIKE ");
                break;
            }
            case 12: {
                buf.append(") LIKE UPPER(");
                break;
            }
            case 38: {
                buf.append(") NOT LIKE UPPER(");
                break;
            }
            case 16: {
                buf.append(" + ");
                break;
            }
            case 17: {
                buf.append(" - ");
                break;
            }
            case 18: {
                buf.append(" * ");
                break;
            }
            case 19: {
                buf.append(" / ");
                break;
            }
            case 9: {
                if (childIndex == 0) {
                    buf.append(" BETWEEN ");
                    break;
                }
                if (childIndex != 1) break;
                buf.append(" AND ");
                break;
            }
            case 35: {
                if (childIndex == 0) {
                    buf.append(" NOT BETWEEN ");
                    break;
                }
                if (childIndex != 1) break;
                buf.append(" AND ");
            }
        }
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(buf.toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }

    public void startNode(Expression node, Expression parentNode) {
        int count = node.getOperandCount();
        if (count == 2) {
            this.detectObjectMatch(node);
        }
        if (this.parenthesisNeeded(node, parentNode)) {
            this.qualBuf.append('(');
        }
        if (count == 1) {
            if (node.getType() == 20) {
                this.qualBuf.append('-');
            } else if (node.getType() == 2) {
                this.qualBuf.append("NOT ");
            } else if (node.getType() == 15) {
                this.qualBuf.append("EXISTS ");
            } else if (node.getType() == 22) {
                this.qualBuf.append("ALL ");
            } else if (node.getType() == 23) {
                this.qualBuf.append("SOME ");
            } else if (node.getType() == 24) {
                this.qualBuf.append("ANY ");
            }
        } else if (node.getType() == 12 || node.getType() == 38) {
            this.qualBuf.append("UPPER(");
        }
    }

    public void endNode(Expression node, Expression parentNode) {
        if (node.getOperandCount() == 2 && this.matchingObject) {
            this.appendObjectMatch();
        }
        if (this.parenthesisNeeded(node, parentNode)) {
            this.qualBuf.append(')');
        }
        if (node.getType() == 12 || node.getType() == 38) {
            this.qualBuf.append(')');
        }
    }

    public void objectNode(Object leaf, Expression parentNode) {
        if (parentNode.getType() == 25) {
            this.appendRawSql(leaf);
        } else if (parentNode.getType() == 26) {
            this.appendObjPath(this.qualBuf, parentNode);
        } else if (parentNode.getType() == 27) {
            this.appendDbPath(this.qualBuf, parentNode);
        } else if (parentNode.getType() == 28) {
            this.appendList(parentNode, this.paramsDbType(parentNode));
        } else {
            this.appendLiteral(this.qualBuf, leaf, this.paramsDbType(parentNode), parentNode);
        }
    }

    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (parentNode == null) {
            return false;
        }
        if (node.getOperandCount() > 1) {
            return true;
        }
        if (node.getType() == 26) {
            return false;
        }
        return node.getType() != 27;
    }

    private void appendRawSql(Object sql) {
        if (sql != null) {
            this.qualBuf.append(sql);
        }
    }

    private final void appendList(Expression listExpr, DbAttribute paramDesc) {
        ResettableIterator it = null;
        Object list = listExpr.getOperand(0);
        if (list instanceof List) {
            it = ((List)list).iterator();
        } else if (list instanceof Object[]) {
            it = IteratorUtils.arrayIterator((Object[])list);
        } else {
            String className = list != null ? list.getClass().getName() : "<null>";
            throw new IllegalArgumentException("Unsupported type for the list expressions: " + className);
        }
        if (it.hasNext()) {
            this.appendLiteral(this.qualBuf, it.next(), paramDesc, listExpr);
        } else {
            return;
        }
        while (it.hasNext()) {
            this.qualBuf.append(", ");
            this.appendLiteral(this.qualBuf, it.next(), paramDesc, listExpr);
        }
    }

    public boolean isTranslateParentQual() {
        return this.translateParentQual;
    }

    public void setTranslateParentQual(boolean translateParentQual) {
        this.translateParentQual = translateParentQual;
    }

    public ObjEntity getObjEntity() {
        if (this.isTranslateParentQual()) {
            SelectQuery query = (SelectQuery)this.queryAssembler.getQuery();
            return this.queryAssembler.getEntityResolver().getObjEntity(query.getParentObjEntityName());
        }
        return super.getObjEntity();
    }

    protected void appendLiteral(StringBuffer buf, Object val, DbAttribute attr, Expression parentExpression) {
        if (!this.matchingObject) {
            super.appendLiteral(buf, val, attr, parentExpression);
        } else if (val == null || val instanceof DataObject) {
            this.objectMatchTranslator.setDataObject((DataObject)val);
        } else if (val instanceof ObjectId) {
            this.objectMatchTranslator.setObjectId((ObjectId)val);
        } else {
            throw new IllegalArgumentException("Attempt to use literal other than DataObject during object match.");
        }
    }

    protected void processRelTermination(StringBuffer buf, DbRelationship rel) {
        if (!this.matchingObject) {
            super.processRelTermination(buf, rel);
        } else {
            if (rel.isToMany()) {
                this.queryAssembler.dbRelationshipAdded(rel);
            }
            this.objectMatchTranslator.setRelationship(rel);
        }
    }
}

