/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.objectstyle.cayenne.conf.AbstractHandler;
import org.objectstyle.cayenne.conf.ConfigLoaderDelegate;
import org.objectstyle.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigLoader {
    protected XMLReader parser;
    protected ConfigLoaderDelegate delegate;

    public ConfigLoader(ConfigLoaderDelegate delegate) throws Exception {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate must not be null.");
        }
        this.delegate = delegate;
        this.parser = Util.createXmlReader();
    }

    public ConfigLoaderDelegate getDelegate() {
        return this.delegate;
    }

    public boolean loadDomains(InputStream in) {
        RootHandler handler = new RootHandler();
        this.parser.setContentHandler(handler);
        this.parser.setErrorHandler(handler);
        try {
            this.delegate.startedLoading();
            this.parser.parse(new InputSource(in));
            this.delegate.finishedLoading();
        }
        catch (IOException ioex) {
            this.getDelegate().loadError(ioex);
        }
        catch (SAXException saxex) {
            this.getDelegate().loadError(saxex);
        }
        return !this.getDelegate().getStatus().hasFailures();
    }

    private class MapRefHandler
    extends AbstractHandler {
        public MapRefHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs, String domainName, String nodeName) {
            String mapName = attrs.getValue("", "name");
            ConfigLoader.this.delegate.shouldLinkDataMap(domainName, nodeName, mapName);
        }
    }

    private class DepMapRefHandler
    extends AbstractHandler {
        public DepMapRefHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs) {
        }
    }

    private class NodeHandler
    extends AbstractHandler {
        protected String nodeName;
        protected String domainName;

        public NodeHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs, String domainName) {
            this.domainName = domainName;
            this.nodeName = attrs.getValue("", "name");
            String dataSrcLocation = attrs.getValue("", "datasource");
            String adapterClass = attrs.getValue("", "adapter");
            String factoryName = attrs.getValue("", "factory");
            ConfigLoader.this.delegate.shouldLoadDataNode(domainName, this.nodeName, dataSrcLocation, adapterClass, factoryName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            if (!localName.equals("map-ref")) {
                throw new SAXParseException("<map-ref> should be the only node child. <" + localName + "> is unexpected.", null);
            }
            new MapRefHandler(this.getParser(), this).init(localName, attrs, this.domainName, this.nodeName);
        }
    }

    private class MapHandler
    extends AbstractHandler {
        protected String domainName;
        protected String mapName;
        protected String location;
        private Map mapLocations;

        public MapHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs, String domainName, Map locations) {
            this.domainName = domainName;
            this.mapLocations = locations;
            this.mapName = attrs.getValue("", "name");
            this.location = attrs.getValue("", "location");
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            if (!localName.equals("dep-map-ref")) {
                throw new SAXParseException("<dep-map-ref> should be the only map child. <" + localName + "> is unexpected.", null);
            }
            new DepMapRefHandler(this.getParser(), this).init(localName, attrs);
        }

        protected void finished() {
            this.mapLocations.put(this.mapName, this.location);
        }
    }

    private class PropertyHandler
    extends AbstractHandler {
        public PropertyHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(Attributes attrs, Map properties) {
            String name = attrs.getValue("", "name");
            String value = attrs.getValue("", "value");
            if (name != null && value != null) {
                properties.put(name, value);
            }
        }
    }

    private class DomainHandler
    extends AbstractHandler {
        private String domainName;
        private Map properties;
        private Map mapLocations;

        public DomainHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(String name, Attributes attrs) {
            this.domainName = attrs.getValue("", "name");
            this.mapLocations = new HashMap();
            this.properties = new HashMap();
            ConfigLoader.this.delegate.shouldLoadDataDomain(this.domainName);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("property")) {
                new PropertyHandler(this.getParser(), this).init(atts, this.properties);
            } else if (localName.equals("map")) {
                this.loadProperties();
                new MapHandler(this.getParser(), this).init(localName, atts, this.domainName, this.mapLocations);
            } else if (localName.equals("node")) {
                this.loadMaps();
                new NodeHandler(this.getParser(), this).init(localName, atts, this.domainName);
            } else {
                String message = "<node> or <map> should be the children of <domain>. <" + localName + "> is unexpected.";
                throw new SAXParseException(message, null);
            }
        }

        protected void finished() {
            this.loadProperties();
            this.loadMaps();
        }

        private void loadProperties() {
            if (this.properties.size() > 0) {
                ConfigLoader.this.delegate.shouldLoadDataDomainProperties(this.domainName, this.properties);
                this.properties.clear();
            }
        }

        private void loadMaps() {
            if (this.mapLocations.size() > 0) {
                ConfigLoader.this.delegate.shouldLoadDataMaps(this.domainName, this.mapLocations);
                this.mapLocations.clear();
            }
        }
    }

    private class ViewHandler
    extends AbstractHandler {
        public ViewHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void init(Attributes attrs) {
            String name = attrs.getValue("", "name");
            String location = attrs.getValue("", "location");
            ConfigLoader.this.delegate.shouldRegisterDataView(name, location);
        }
    }

    private class DomainsHandler
    extends AbstractHandler {
        public DomainsHandler(XMLReader parser, ContentHandler parentHandler) {
            super(parser, parentHandler);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.equals("domain")) {
                new DomainHandler(this.getParser(), this).init(localName, atts);
            } else if (localName.equals("view")) {
                new ViewHandler(this.getParser(), this).init(atts);
            } else {
                String message = "<domain> or <view> are only valid children of <domains>. <" + localName + "> is unexpected.";
                throw new SAXParseException(message, null);
            }
        }
    }

    private class RootHandler
    extends DefaultHandler {
        private RootHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
            if (!localName.equals("domains")) {
                throw new SAXParseException("<domains> should be the root element. <" + localName + "> is unexpected.", null);
            }
            ConfigLoader.this.delegate.shouldLoadProjectVersion(attrs.getValue("", "project-version"));
            new DomainsHandler(ConfigLoader.this.parser, this);
        }
    }
}

