/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConfigStatus {
    protected List otherFailures = new ArrayList();
    protected Map failedMaps = new HashMap();
    protected Map failedAdapters = new HashMap();
    protected Map failedDataSources = new HashMap();
    protected List failedMapRefs = new ArrayList();
    protected Map messages = new HashMap();

    public void addFailedMap(String name, String location, Object extraMessage) {
        this.failedMaps.put(name, location);
        if (extraMessage != null) {
            this.messages.put(this.getMapMessageKey(name, location), extraMessage);
        }
    }

    public void addFailedAdapter(String name, String location, String extraMessage) {
        this.failedAdapters.put(name, location);
        if (extraMessage != null) {
            this.messages.put(this.getAdapterMessageKey(name, location), extraMessage);
        }
    }

    public void addFailedDataSource(String name, String location, String extraMessage) {
        this.failedDataSources.put(name, location);
        if (extraMessage != null) {
            this.messages.put(this.getDataSourceMessageKey(name, location), extraMessage);
        }
    }

    public void addFailedMapRefs(String name, String extraMessage) {
        this.failedMapRefs.add(name);
        if (extraMessage != null) {
            this.messages.put(this.getMapRefMessageKey(name), extraMessage);
        }
    }

    protected String getMapMessageKey(String name, String location) {
        return "map:" + name + ":" + location;
    }

    protected String getAdapterMessageKey(String name, String location) {
        return "adapter:" + name + ":" + location;
    }

    protected String getDataSourceMessageKey(String name, String location) {
        return "dataSource:" + name + ":" + location;
    }

    protected String getMapRefMessageKey(String name) {
        return "map-ref:" + name;
    }

    public String describeFailures() {
        String node;
        Object message;
        String location;
        if (!this.hasFailures()) {
            return "[No failures]";
        }
        StringBuffer buf = new StringBuffer();
        Iterator<Object> it = this.failedMaps.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            location = (String)this.failedMaps.get(name);
            message = this.messages.get(this.getMapMessageKey(name, location));
            buf.append("\n\tdomain.map.name=").append(name).append(", domain.map.location=").append(location);
            if (message == null) continue;
            buf.append(", reason: ").append(message);
        }
        it = this.failedAdapters.keySet().iterator();
        while (it.hasNext()) {
            node = (String)it.next();
            String adapter = (String)this.failedAdapters.get(node);
            message = this.messages.get(this.getAdapterMessageKey(node, adapter));
            buf.append("\n\tdomain.node.name=").append(node).append(", domain.node.adapter=").append(adapter);
            if (message == null) continue;
            buf.append(", reason: ").append(message);
        }
        it = this.failedDataSources.keySet().iterator();
        while (it.hasNext()) {
            node = (String)it.next();
            location = (String)this.failedDataSources.get(node);
            message = this.messages.get(this.getDataSourceMessageKey(node, location));
            buf.append("\n\tdomain.node.name=").append(node).append(", domain.node.datasource=").append(location);
            if (message == null) continue;
            buf.append(", reason: ").append(message);
        }
        it = this.failedMapRefs.iterator();
        while (it.hasNext()) {
            String mapName = (String)it.next();
            if (this.failedMaps.get(mapName) != null) continue;
            buf.append("\n\tdomain.node.map-ref.name=").append(mapName);
            Object message2 = this.messages.get(this.getMapRefMessageKey(mapName));
            if (message2 == null) continue;
            buf.append(", reason: ").append(message2);
        }
        return buf.toString();
    }

    public List getOtherFailures() {
        return this.otherFailures;
    }

    public List getFailedMapRefs() {
        return this.failedMapRefs;
    }

    public Map getFailedMaps() {
        return this.failedMaps;
    }

    public Map getFailedDataSources() {
        return this.failedDataSources;
    }

    public Map getFailedAdapters() {
        return this.failedAdapters;
    }

    public boolean hasFailures() {
        return this.failedMaps.size() > 0 || this.failedDataSources.size() > 0 || this.failedAdapters.size() > 0 || this.failedMapRefs.size() > 0 || this.otherFailures.size() > 0;
    }
}

