/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ConfigurationException;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.conf.ConfigLoaderDelegate;
import org.objectstyle.cayenne.conf.ConfigSaverDelegate;
import org.objectstyle.cayenne.conf.ConfigStatus;
import org.objectstyle.cayenne.conf.DataSourceFactory;
import org.objectstyle.cayenne.conf.DefaultConfiguration;
import org.objectstyle.cayenne.dataview.DataView;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.util.CayenneMap;
import org.objectstyle.cayenne.util.ResourceLocator;

public abstract class Configuration {
    private static Logger logObj = Logger.getLogger(Configuration.class);
    public static final String DEFAULT_LOGGING_PROPS_FILE = ".cayenne/cayenne-log.properties";
    public static final String DEFAULT_DOMAIN_FILE = "cayenne.xml";
    public static final Class DEFAULT_CONFIGURATION_CLASS = DefaultConfiguration.class;
    protected static Configuration sharedConfiguration = null;
    private static boolean loggingConfigured = false;
    public static final Predicate ACCEPT_ALL_DATAVIEWS = new Predicate(){

        public boolean evaluate(Object dataViewName) {
            return true;
        }
    };
    protected CayenneMap dataDomains = new CayenneMap(this);
    protected DataSourceFactory overrideFactory;
    protected ConfigStatus loadStatus = new ConfigStatus();
    protected String domainConfigurationName = "cayenne.xml";
    protected boolean ignoringLoadFailures;
    protected ConfigLoaderDelegate loaderDelegate;
    protected ConfigSaverDelegate saverDelegate;
    protected ConfigurationShutdownHook configurationShutdownHook = new ConfigurationShutdownHook();
    protected Map dataViewLocations = new HashMap();
    protected String projectVersion;
    protected EventManager eventManager;

    public static void bootstrapSharedConfiguration(Class cl) {
        logObj.warn("This method does nothing.");
    }

    public static synchronized void configureCommonLogging() {
        if (!Configuration.isLoggingConfigured()) {
            ResourceLocator locator = new ResourceLocator();
            locator.setSkipAbsolutePath(true);
            locator.setSkipClasspath(false);
            locator.setSkipCurrentDirectory(true);
            locator.setSkipHomeDirectory(false);
            URL configURL = locator.findResource(DEFAULT_LOGGING_PROPS_FILE);
            Configuration.configureCommonLogging(configURL);
        }
    }

    public static synchronized void configureCommonLogging(URL propsFile) {
        if (!Configuration.isLoggingConfigured()) {
            if (propsFile != null) {
                PropertyConfigurator.configure(propsFile);
                logObj.debug("configured log4j from: " + propsFile);
            } else {
                BasicConfigurator.configure();
                logObj.debug("configured log4j with BasicConfigurator.");
            }
            Configuration.setLoggingConfigured(true);
        }
    }

    public static boolean isLoggingConfigured() {
        if (!loggingConfigured && Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            Configuration.setLoggingConfigured(true);
        }
        return loggingConfigured;
    }

    public static synchronized void setLoggingConfigured(boolean state) {
        loggingConfigured = state;
    }

    public static synchronized Configuration getSharedConfiguration() {
        if (sharedConfiguration == null) {
            Configuration.initializeSharedConfiguration();
        }
        return sharedConfiguration;
    }

    public static ClassLoader getResourceLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = Configuration.class.getClassLoader();
        }
        return loader;
    }

    public static Level getLoggingLevel() {
        Level l = logObj.getLevel();
        return l != null ? l : Level.DEBUG;
    }

    public static void setLoggingLevel(Level logLevel) {
        logObj.setLevel(logLevel);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public static void initializeSharedConfiguration() {
        Configuration.initializeSharedConfiguration(DEFAULT_CONFIGURATION_CLASS);
    }

    public static void initializeSharedConfiguration(Class configurationClass) {
        Configuration conf = null;
        try {
            conf = (Configuration)configurationClass.newInstance();
        }
        catch (Exception ex) {
            logObj.error("Error creating shared Configuration: ", ex);
            throw new ConfigurationException("Error creating shared Configuration." + ex.getMessage(), ex);
        }
        Configuration.initializeSharedConfiguration(conf);
    }

    public static void initializeSharedConfiguration(Configuration conf) {
        if (!conf.canInitialize()) {
            throw new ConfigurationException("Configuration of class " + conf.getClass().getName() + " refused to be initialized.");
        }
        try {
            conf.initialize();
            conf.didInitialize();
            sharedConfiguration = conf;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Error during Configuration initialization. " + ex.getMessage(), ex);
        }
    }

    protected Configuration() {
        this(DEFAULT_DOMAIN_FILE);
    }

    protected Configuration(String domainConfigurationName) {
        this.configureLogging();
        this.setDomainConfigurationName(domainConfigurationName);
        this.eventManager = new EventManager();
    }

    public abstract boolean canInitialize();

    public abstract void initialize() throws Exception;

    public abstract void didInitialize();

    protected abstract ResourceLocator getResourceLocator();

    protected abstract InputStream getDomainConfiguration();

    protected abstract InputStream getMapConfiguration(String var1);

    protected abstract InputStream getViewConfiguration(String var1);

    protected void configureLogging() {
        Configuration.configureCommonLogging();
    }

    public String getDomainConfigurationName() {
        return this.domainConfigurationName;
    }

    protected void setDomainConfigurationName(String domainConfigurationName) {
        this.domainConfigurationName = domainConfigurationName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.overrideFactory;
    }

    public void setDataSourceFactory(DataSourceFactory overrideFactory) {
        this.overrideFactory = overrideFactory;
    }

    public void addDomain(DataDomain domain) {
        this.dataDomains.put(domain.getName(), domain);
        if (domain != null) {
            domain.setEventManager(this.getEventManager());
        }
        logObj.debug("added domain: " + domain.getName());
    }

    public DataDomain getDomain(String name) {
        return (DataDomain)this.dataDomains.get(name);
    }

    public DataDomain getDomain() {
        int size = this.dataDomains.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (DataDomain)this.dataDomains.values().iterator().next();
        }
        throw new CayenneRuntimeException("More than one domain is configured; use 'getDomain(String name)' instead.");
    }

    public void removeDomain(String name) {
        DataDomain domain = (DataDomain)this.dataDomains.remove(name);
        if (domain != null) {
            domain.setEventManager(null);
        }
        logObj.debug("removed domain: " + name);
    }

    public Collection getDomains() {
        return Collections.unmodifiableCollection(this.dataDomains.values());
    }

    public boolean isIgnoringLoadFailures() {
        return this.ignoringLoadFailures;
    }

    protected void setIgnoringLoadFailures(boolean ignoringLoadFailures) {
        this.ignoringLoadFailures = ignoringLoadFailures;
    }

    public ConfigStatus getLoadStatus() {
        return this.loadStatus;
    }

    protected void setLoadStatus(ConfigStatus status) {
        this.loadStatus = status;
    }

    public ConfigLoaderDelegate getLoaderDelegate() {
        return this.loaderDelegate;
    }

    public void setLoaderDelegate(ConfigLoaderDelegate loaderDelegate) {
        this.loaderDelegate = loaderDelegate;
    }

    public ConfigSaverDelegate getSaverDelegate() {
        return this.saverDelegate;
    }

    public void setSaverDelegate(ConfigSaverDelegate saverDelegate) {
        this.saverDelegate = saverDelegate;
    }

    public void setDataViewLocations(Map dataViewLocations) {
        this.dataViewLocations = dataViewLocations == null ? new HashMap() : dataViewLocations;
    }

    public Map getDataViewLocations() {
        return this.dataViewLocations;
    }

    public boolean loadDataView(DataView dataView) throws IOException {
        return this.loadDataView(dataView, ACCEPT_ALL_DATAVIEWS);
    }

    public boolean loadDataView(DataView dataView, Predicate dataViewNameFilter) throws IOException {
        if (dataView == null) {
            throw new IllegalArgumentException("DataView cannot be null.");
        }
        if (this.dataViewLocations.size() == 0 || this.dataViewLocations.size() > 512) {
            return false;
        }
        if (dataViewNameFilter == null) {
            dataViewNameFilter = ACCEPT_ALL_DATAVIEWS;
        }
        ArrayList<InputStream> viewXMLSources = new ArrayList<InputStream>(this.dataViewLocations.size());
        int index = 0;
        Iterator i = this.dataViewLocations.entrySet().iterator();
        while (i.hasNext()) {
            String location;
            InputStream in;
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            if (dataViewNameFilter.evaluate(name) && (in = this.getViewConfiguration(location = (String)entry.getValue())) != null) {
                viewXMLSources.add(in);
            }
            ++index;
        }
        if (viewXMLSources.isEmpty()) {
            return false;
        }
        dataView.load(viewXMLSources.toArray(new InputStream[viewXMLSources.size()]));
        return true;
    }

    public void shutdown() {
        Collection domains = this.getDomains();
        Iterator i = domains.iterator();
        while (i.hasNext()) {
            DataDomain domain = (DataDomain)i.next();
            domain.shutdown();
        }
    }

    public void installConfigurationShutdownHook() {
        this.uninstallConfigurationShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.configurationShutdownHook);
    }

    public void uninstallConfigurationShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(this.configurationShutdownHook);
    }

    private class ConfigurationShutdownHook
    extends Thread {
        private ConfigurationShutdownHook() {
        }

        public void run() {
            Configuration.this.shutdown();
        }
    }
}

