/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.conf.DefaultConfiguration;
import org.objectstyle.cayenne.util.ResourceLocator;
import org.objectstyle.cayenne.util.WebApplicationResourceLocator;

public class ServletUtil {
    private static Logger logObj = Logger.getLogger(ServletUtil.class);
    public static final String CONFIGURATION_PATH_KEY = "cayenne.configuration.path";
    public static final String DATA_CONTEXT_KEY = "cayenne.datacontext";

    public static synchronized Configuration initializeSharedConfiguration(ServletContext context) {
        ResourceLocator locator;
        Configuration oldConfig = Configuration.sharedConfiguration;
        if (oldConfig instanceof DefaultConfiguration && (locator = ((DefaultConfiguration)oldConfig).getResourceLocator()) instanceof WebApplicationResourceLocator && ((WebApplicationResourceLocator)locator).getServletContext() == context) {
            logObj.info("Configuration is already initialized with this context, reusing.");
            return oldConfig;
        }
        DefaultConfiguration conf = new DefaultConfiguration("cayenne.xml", ServletUtil.createLocator(context));
        Configuration.initializeSharedConfiguration(conf);
        return conf;
    }

    protected static ResourceLocator createLocator(ServletContext context) {
        WebApplicationResourceLocator locator = new WebApplicationResourceLocator();
        locator.setSkipAbsolutePath(true);
        locator.setSkipClasspath(false);
        locator.setSkipCurrentDirectory(true);
        locator.setSkipHomeDirectory(true);
        locator.setServletContext(context);
        String configurationPath = context.getInitParameter(CONFIGURATION_PATH_KEY);
        if (configurationPath != null && configurationPath.trim().length() > 0) {
            locator.addFilesystemPath(configurationPath.trim());
        }
        return locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataContext getSessionContext(HttpSession session) {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            DataContext ctxt = (DataContext)session.getAttribute(DATA_CONTEXT_KEY);
            if (ctxt == null) {
                ctxt = DataContext.createDataContext();
                session.setAttribute(DATA_CONTEXT_KEY, (Object)ctxt);
            }
            return ctxt;
        }
    }
}

