/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.conf;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.access.DataContext;
import org.objectstyle.cayenne.conf.ServletUtil;

public class WebApplicationContextFilter
implements Filter {
    private static Logger logger = Logger.getLogger(WebApplicationContextFilter.class);

    public void destroy() {
    }

    public synchronized void init(FilterConfig config) throws ServletException {
        ServletUtil.initializeSharedConfiguration(config.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug("start WebApplicationContextFilter.doFilter. URL - " + ((HttpServletRequest)request).getRequestURL());
        }
        if (request instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            DataContext dataContext = ServletUtil.getSessionContext(session);
            if (dataContext == null) {
                logger.debug("DataContext was null. Throwing Exception");
                throw new ServletException("DataContext was null and could not be bound to thread.");
            }
            DataContext.bindThreadDataContext(dataContext);
            logger.debug("DataContext bound, continuing in chain");
        } else {
            logger.debug("requests that are not HttpServletRequest are not supported..");
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            DataContext.bindThreadDataContext(null);
        }
    }
}

