/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dataview;

import java.text.Format;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.dataview.CalcTypeEnum;
import org.objectstyle.cayenne.dataview.DataTypeEnum;
import org.objectstyle.cayenne.dataview.DataView;
import org.objectstyle.cayenne.dataview.ObjEntityView;
import org.objectstyle.cayenne.map.ObjAttribute;
import org.objectstyle.cayenne.map.ObjRelationship;

public class ObjEntityViewField {
    private ObjEntityView owner;
    private ObjAttribute objAttribute;
    private ObjRelationship objRelationship;
    private String name = "";
    private DataTypeEnum dataType = DataTypeEnum.UNKNOWN_TYPE;
    private CalcTypeEnum calcType = CalcTypeEnum.NO_CALC_TYPE;
    private String caption = "";
    private Format displayFormat = null;
    private Format editFormat = null;
    private int preferredIndex = -1;
    private int index = -1;
    private boolean editable = true;
    private boolean visible = true;
    private Object defaultValue = null;
    private ObjEntityViewField lookupField = null;

    public ObjEntityView getOwner() {
        return this.owner;
    }

    public DataView getRootOwner() {
        return this.getOwner().getOwner();
    }

    public int getIndex() {
        return this.index;
    }

    public int getPreferredIndex() {
        return this.preferredIndex;
    }

    public void setPreferredIndex(int preferredIndex) {
        Validate.isTrue(preferredIndex >= -1);
        this.preferredIndex = preferredIndex;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Validate.notNull(name);
        this.name = name;
    }

    public ObjAttribute getObjAttribute() {
        return this.objAttribute;
    }

    public void setObjAttribute(ObjAttribute objAttribute) {
        Validate.notNull(objAttribute);
        this.objAttribute = objAttribute;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    void setOwner(ObjEntityView owner) {
        this.owner = owner;
    }

    void setIndex(int index) {
        Validate.isTrue(this.owner == null || index >= 0);
        this.index = index;
    }

    public Class getJavaClass() {
        return this.getRootOwner().getDataTypeSpec().getJavaClass(this.dataType);
    }

    public Object getValue(DataObject obj) {
        Object rawValue = this.getRawValue(obj);
        return this.toValue(rawValue);
    }

    public Object toValue(Object rawValue) {
        Object v = null;
        if (this.isLookup()) {
            if (rawValue instanceof DataObject) {
                v = this.lookupField.getValue((DataObject)rawValue);
            }
            return v;
        }
        if (rawValue == null) {
            return null;
        }
        v = this.getRootOwner().getDataTypeSpec().toDataType(this.dataType, rawValue);
        return v;
    }

    public Object toRawValue(Object value) {
        if (value == null) {
            return null;
        }
        DataView rootOwner = this.getOwner().getOwner();
        if (this.isLookup()) {
            return rootOwner.getLookupCache().getDataObject(this.lookupField, value);
        }
        if (this.objAttribute == null) {
            return null;
        }
        String type = this.objAttribute.getType();
        Object v = null;
        try {
            Class<?> untypedValueClass = Class.forName(type);
            v = rootOwner.getDataTypeSpec().fromDataType(untypedValueClass, this.dataType, value);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return v;
    }

    public void setValue(DataObject obj, Object value) {
        Object rawValue = this.toRawValue(value);
        Object oldValue = this.getValue(obj);
        this.setRawValue(obj, rawValue);
        this.getRootOwner().fireFieldValueChangeEvent(this, obj, oldValue, value);
    }

    public String getFormattedValue(DataObject obj) {
        Object value = this.getRawValue(obj);
        String formattedValue = null;
        if (!this.isLookup()) {
            Format f;
            Format format = f = this.displayFormat != null ? this.displayFormat : this.editFormat;
            if (f == null) {
                formattedValue = ObjectUtils.toString(value);
            } else {
                try {
                    formattedValue = f.format(value);
                }
                catch (Exception ex) {
                    formattedValue = "";
                }
            }
        } else {
            formattedValue = this.lookupField.getFormattedValue((DataObject)value);
        }
        return formattedValue;
    }

    public Object getRawValue(DataObject obj) {
        if (obj == null) {
            return null;
        }
        Object value = null;
        if (!this.isLookup() && this.objAttribute != null) {
            value = obj.readProperty(this.objAttribute.getName());
        } else if (this.isLookup() && this.objRelationship != null) {
            value = obj.readProperty(this.objRelationship.getName());
        }
        return value;
    }

    public void setRawValue(DataObject obj, Object value) {
        if (obj != null) {
            if (!this.isLookup() && this.objAttribute != null) {
                obj.writeProperty(this.objAttribute.getName(), value);
            } else if (this.isLookup() && this.objRelationship != null) {
                obj.setToOneTarget(this.objRelationship.getName(), (DataObject)value, this.objRelationship.getReverseRelationship() != null);
            }
        }
    }

    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        Validate.notNull(dataType);
        this.dataType = dataType;
    }

    public CalcTypeEnum getCalcType() {
        return this.calcType;
    }

    public void setCalcType(CalcTypeEnum calcType) {
        Validate.notNull(calcType);
        this.calcType = calcType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ObjRelationship getObjRelationship() {
        return this.objRelationship;
    }

    public void setObjRelationship(ObjRelationship objRelationship) {
        Validate.notNull(objRelationship);
        this.objRelationship = objRelationship;
    }

    public boolean isLookup() {
        return CalcTypeEnum.LOOKUP_TYPE.equals(this.calcType);
    }

    public Object[] getLookupValues() {
        if (!this.isLookup()) {
            return null;
        }
        return this.getRootOwner().getLookupCache().getCachedValues(this.lookupField);
    }

    public ObjEntityViewField getLookupField() {
        return this.lookupField;
    }

    public void setLookupField(ObjEntityViewField lookupField) {
        this.lookupField = lookupField;
    }

    public Format getDisplayFormat() {
        if (this.displayFormat == null && this.isLookup() && this.lookupField != null && this.lookupField != this) {
            return this.lookupField.getDisplayFormat();
        }
        return this.displayFormat;
    }

    public void setDisplayFormat(Format displayFormat) {
        this.displayFormat = displayFormat;
    }

    public Format getEditFormat() {
        if (this.editFormat == null && this.isLookup() && this.lookupField != null && this.lookupField != this) {
            return this.lookupField.getEditFormat();
        }
        return this.editFormat;
    }

    public void setEditFormat(Format editFormat) {
        this.editFormat = editFormat;
    }

    public boolean isSameObjAttribute(ObjEntityViewField field) {
        if (this.objAttribute != null) {
            ObjAttribute fieldAttribute = field.getObjAttribute();
            if (fieldAttribute == null) {
                return false;
            }
            boolean same = this.objAttribute.equals(fieldAttribute) || this.objAttribute.getEntity().equals(fieldAttribute.getEntity()) && this.objAttribute.getName().equals(fieldAttribute.getName());
            return same;
        }
        if (this.isLookup()) {
            if (field.isLookup()) {
                return this.getLookupField().isSameObjAttribute(field.getLookupField());
            }
            return this.getLookupField().isSameObjAttribute(field);
        }
        return false;
    }
}

