/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.DbAdapterFactory;

class DbAdapterFactoryChain
implements DbAdapterFactory {
    private static final Logger logObj = Logger.getLogger(DbAdapterFactoryChain.class);
    List factories = new ArrayList();

    DbAdapterFactoryChain(Collection factories) {
        this.factories.addAll(factories);
    }

    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        if (logObj.isInfoEnabled()) {
            logObj.info("DB name: " + md.getDatabaseProductName());
        }
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            DbAdapterFactory factory = (DbAdapterFactory)this.factories.get(i);
            DbAdapter adapter = factory.createAdapter(md);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }

    void clearFactories() {
        this.factories.clear();
    }

    void addFactory(DbAdapterFactory factory) {
        this.factories.add(factory);
    }
}

