/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TypesHandler {
    private static Logger logObj = Logger.getLogger(TypesHandler.class);
    private static Map handlerMap = new HashMap();
    protected Map typesMap;
    static /* synthetic */ Class class$java$sql$Types;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypesHandler getHandler(URL typesConfig) {
        Map map = handlerMap;
        synchronized (map) {
            TypesHandler handler = (TypesHandler)handlerMap.get(typesConfig);
            if (handler == null) {
                handler = new TypesHandler(typesConfig);
                handlerMap.put(typesConfig, handler);
            }
            return handler;
        }
    }

    public TypesHandler(URL typesConfig) {
        try {
            InputStream in = typesConfig.openStream();
            try {
                XMLReader parser = Util.createXmlReader();
                TypesParseHandler ph = new TypesParseHandler();
                parser.setContentHandler(ph);
                parser.setErrorHandler(ph);
                parser.parse(new InputSource(in));
                this.typesMap = ph.getTypes();
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error creating TypesHandler '" + typesConfig + "'.", ex);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioex) {}
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error opening config file '" + typesConfig + "'.", ioex);
        }
    }

    public String[] externalTypesForJdbcType(int type) {
        return (String[])this.typesMap.get(new Integer(type));
    }

    final class TypesParseHandler
    extends DefaultHandler {
        private static final String JDBC_TYPE_TAG = "jdbc-type";
        private static final String DB_TYPE_TAG = "db-type";
        private static final String NAME_ATTR = "name";
        private Map types = new HashMap();
        private List currentTypes = new ArrayList();
        private int currentType = Integer.MAX_VALUE;

        TypesParseHandler() {
        }

        public Map getTypes() {
            return this.types;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (JDBC_TYPE_TAG.equals(localName)) {
                this.currentTypes.clear();
                String strType = atts.getValue("", NAME_ATTR);
                try {
                    this.currentType = (class$java$sql$Types == null ? (class$java$sql$Types = TypesHandler.class$("java.sql.Types")) : class$java$sql$Types).getDeclaredField(strType).getInt(null);
                }
                catch (Exception ex) {
                    this.currentType = Integer.MAX_VALUE;
                    logObj.info("type not found: '" + strType + "', ignoring.");
                }
            } else if (DB_TYPE_TAG.equals(localName)) {
                this.currentTypes.add(atts.getValue("", NAME_ATTR));
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (JDBC_TYPE_TAG.equals(localName) && this.currentType != Integer.MAX_VALUE) {
                String[] typesAsArray = new String[this.currentTypes.size()];
                this.types.put(new Integer(this.currentType), this.currentTypes.toArray(typesAsArray));
            }
        }
    }
}

