/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.mysql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.types.ByteArrayType;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.mysql.MySQLActionBuilder;
import org.objectstyle.cayenne.dba.mysql.MySQLPkGenerator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DbRelationship;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;

public class MySQLAdapter
extends JdbcAdapter {
    public MySQLAdapter() {
        this.setSupportsFkConstraints(false);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new MySQLActionBuilder(this, node.getEntityResolver()));
    }

    public String dropTable(DbEntity entity) {
        return "DROP TABLE IF EXISTS " + entity.getFullyQualifiedName() + " CASCADE";
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(false, false));
        map.registerType(new ByteArrayType(false, false));
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (type == 1111) {
            if ("longblob".equalsIgnoreCase(typeName)) {
                type = 2004;
            } else if ("mediumblob".equalsIgnoreCase(typeName)) {
                type = 2004;
            } else if ("blob".equalsIgnoreCase(typeName)) {
                type = 2004;
            } else if ("tinyblob".equalsIgnoreCase(typeName)) {
                type = -3;
            } else if ("longtext".equalsIgnoreCase(typeName)) {
                type = 2005;
            } else if ("mediumtext".equalsIgnoreCase(typeName)) {
                type = 2005;
            } else if ("text".equalsIgnoreCase(typeName)) {
                type = 2005;
            } else if ("tinytext".equalsIgnoreCase(typeName)) {
                type = 12;
            }
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    public String tableTypeForView() {
        return null;
    }

    protected PkGenerator createPkGenerator() {
        return new MySQLPkGenerator();
    }

    public String createTable(DbEntity entity) {
        String ddlSQL = super.createTable(entity);
        if (this.supportsFkConstraints()) {
            ddlSQL = ddlSQL + " ENGINE=InnoDB";
        }
        return ddlSQL;
    }

    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        ArrayList pkList = new ArrayList(entity.getPrimaryKey());
        Collections.sort(pkList, new PKComparator());
        Iterator pkit = pkList.iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                sqlBuffer.append(at.getName());
            }
            sqlBuffer.append(')');
        }
        if (this.supportsFkConstraints()) {
            Iterator relationships = entity.getRelationships().iterator();
            while (relationships.hasNext()) {
                DbRelationship relationship = (DbRelationship)relationships.next();
                if (relationship.getJoins().size() <= 0 || !relationship.isToPK() || relationship.isToDependentPK()) continue;
                sqlBuffer.append(", KEY (");
                Iterator columns = relationship.getSourceAttributes().iterator();
                DbAttribute column = (DbAttribute)columns.next();
                sqlBuffer.append(column.getName());
                while (columns.hasNext()) {
                    column = (DbAttribute)columns.next();
                    sqlBuffer.append(", ").append(column.getName());
                }
                sqlBuffer.append(")");
            }
        }
    }

    protected void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        super.createTableAppendColumn(sqlBuffer, column);
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    final class PKComparator
    implements Comparator {
        PKComparator() {
        }

        public int compare(Object o1, Object o2) {
            DbAttribute a1 = (DbAttribute)o1;
            DbAttribute a2 = (DbAttribute)o2;
            if (a1.isGenerated() != a2.isGenerated()) {
                return a1.isGenerated() ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

