/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.oracle;

import org.objectstyle.cayenne.dba.DbAdapter;
import org.objectstyle.cayenne.dba.JdbcActionBuilder;
import org.objectstyle.cayenne.dba.oracle.OracleAdapter;
import org.objectstyle.cayenne.dba.oracle.OracleBatchAction;
import org.objectstyle.cayenne.dba.oracle.OracleLOBBatchAction;
import org.objectstyle.cayenne.dba.oracle.OracleProcedureAction;
import org.objectstyle.cayenne.dba.oracle.OracleSelectAction;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.query.BatchQuery;
import org.objectstyle.cayenne.query.ProcedureQuery;
import org.objectstyle.cayenne.query.SQLAction;
import org.objectstyle.cayenne.query.SelectQuery;

class OracleActionBuilder
extends JdbcActionBuilder {
    OracleActionBuilder(DbAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    public SQLAction batchAction(BatchQuery query) {
        if (OracleAdapter.isSupportsOracleLOB() && OracleAdapter.updatesLOBColumns(query)) {
            return new OracleLOBBatchAction(query, this.getAdapter());
        }
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        OracleBatchAction action = new OracleBatchAction(query, this.getAdapter(), this.getEntityResolver());
        action.setBatch(runningAsBatch);
        return action;
    }

    public SQLAction procedureAction(ProcedureQuery query) {
        return new OracleProcedureAction(query, this.getAdapter(), this.getEntityResolver());
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new OracleSelectAction(query, this.getAdapter(), this.getEntityResolver());
    }
}

