/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.oracle;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.access.QueryLogger;
import org.objectstyle.cayenne.access.trans.SelectTranslator;
import org.objectstyle.cayenne.query.QueryMetadata;

public class OracleSelectTranslator
extends SelectTranslator {
    private static Logger logObj = Logger.getLogger(OracleSelectTranslator.class);
    private static boolean testedDriver;
    private static boolean useOptimizations;
    private static Method statementSetRowPrefetch;
    private static final Object[] rowPrefetchArgs;

    public String createSqlString() throws Exception {
        String sqlString = super.createSqlString();
        QueryMetadata info = this.getQuery().getMetaData(this.getEntityResolver());
        if (info.getFetchLimit() > 0) {
            sqlString = "SELECT * FROM (" + sqlString + ") WHERE rownum <= " + info.getFetchLimit();
        }
        return sqlString;
    }

    private static final synchronized void testDriver(Statement st) {
        if (testedDriver) {
            return;
        }
        if (st == null) {
            return;
        }
        testedDriver = true;
        try {
            Class[] args2 = new Class[]{Integer.TYPE};
            statementSetRowPrefetch = st.getClass().getMethod("setRowPrefetch", args2);
            useOptimizations = true;
        }
        catch (Exception ex) {
            useOptimizations = false;
            statementSetRowPrefetch = null;
            StringBuffer buf = new StringBuffer();
            buf.append("Unknown Oracle statement type: [").append(st.getClass().getName()).append("]. No Oracle optimizations applied.");
            logObj.info(buf.toString());
        }
    }

    public PreparedStatement createStatement() throws Exception {
        String sqlStr = this.createSqlString();
        QueryLogger.logQuery(sqlStr, this.values);
        PreparedStatement stmt = this.connection.prepareStatement(sqlStr);
        this.initStatement(stmt);
        if (!testedDriver) {
            OracleSelectTranslator.testDriver(stmt);
        }
        if (useOptimizations) {
            statementSetRowPrefetch.invoke((Object)stmt, rowPrefetchArgs);
        }
        return stmt;
    }

    static {
        rowPrefetchArgs = new Object[]{new Integer(100)};
    }
}

