/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.dba.postgres;

import java.util.Iterator;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.access.DataNode;
import org.objectstyle.cayenne.access.trans.QualifierTranslator;
import org.objectstyle.cayenne.access.trans.QueryAssembler;
import org.objectstyle.cayenne.access.types.CharType;
import org.objectstyle.cayenne.access.types.ExtendedTypeMap;
import org.objectstyle.cayenne.dba.JdbcAdapter;
import org.objectstyle.cayenne.dba.PkGenerator;
import org.objectstyle.cayenne.dba.TypesMapping;
import org.objectstyle.cayenne.dba.postgres.PostgresActionBuilder;
import org.objectstyle.cayenne.dba.postgres.PostgresByteArrayType;
import org.objectstyle.cayenne.dba.postgres.PostgresPkGenerator;
import org.objectstyle.cayenne.dba.postgres.PostgresQualifierTranslator;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.map.DerivedDbEntity;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.SQLAction;

public class PostgresAdapter
extends JdbcAdapter {
    public PostgresAdapter() {
        this.setSupportsBatchUpdates(true);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new PostgresActionBuilder(this, node.getEntityResolver()));
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new PostgresByteArrayType(true, true));
    }

    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if ("bytea".equalsIgnoreCase(typeName)) {
            type = -4;
        } else if ("oid".equals(typeName)) {
            type = 2004;
        } else if ("text".equalsIgnoreCase(typeName)) {
            type = 2005;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (this.typeSupportsLength(at.getType())) {
                int prec;
                int len = at.getMaxLength();
                int n = prec = TypesMapping.isDecimal(at.getType()) ? at.getPrecision() : -1;
                if (prec > len) {
                    prec = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (prec >= 0) {
                        buf.append(", ").append(prec);
                    }
                    buf.append(')');
                }
            }
            if (at.isMandatory()) {
                buf.append(" NOT NULL");
                continue;
            }
            buf.append(" NULL");
        }
        Iterator pkit = ent.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    private boolean typeSupportsLength(int type) {
        String[] externalTypes = this.externalTypesForJdbcType(type);
        if (externalTypes != null && externalTypes.length > 0) {
            for (int i = 0; i < externalTypes.length; ++i) {
                if (!"bytea".equalsIgnoreCase(externalTypes[i])) continue;
                return false;
            }
        }
        return TypesMapping.supportsLength(type);
    }

    public String dropTable(DbEntity ent) {
        return super.dropTable(ent) + " CASCADE";
    }

    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        return new PostgresQualifierTranslator(queryAssembler);
    }

    protected PkGenerator createPkGenerator() {
        return new PostgresPkGenerator();
    }
}

