/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.exp;

import java.util.Collection;
import java.util.regex.Pattern;
import org.objectstyle.cayenne.DataObject;
import org.objectstyle.cayenne.exp.ASTStack;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionException;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.property.PropertyUtils;
import org.objectstyle.cayenne.util.Util;

abstract class ASTNode {
    protected ASTNode nextNode;

    ASTNode() {
    }

    static ASTNode buildObjectNode(Object object, ASTNode parent) {
        PushNode node = new PushNode(object);
        return parent != null ? parent.wrapChildNode(node) : node;
    }

    static ASTNode buildExpressionNode(Expression expression, ASTNode parent) {
        ASTNode node;
        switch (expression.getType()) {
            case 26: 
            case 27: {
                node = new PropertyNode(expression);
                break;
            }
            case 3: {
                node = new EqualsNode();
                break;
            }
            case 1: {
                node = new OrNode();
                break;
            }
            case 0: {
                node = new AndNode();
                break;
            }
            case 2: {
                node = new NotNode();
                break;
            }
            case 28: {
                node = new ListNode(expression.getOperand(0));
                break;
            }
            case 4: {
                node = new NotEqualsNode();
                break;
            }
            case 5: {
                node = new LessThanNode();
                break;
            }
            case 7: {
                node = new LessThanEqualsToNode();
                break;
            }
            case 6: {
                node = new GreaterThanNode();
                break;
            }
            case 8: {
                node = new GreaterThanEqualsToNode();
                break;
            }
            case 9: {
                node = new BetweenNode(false);
                break;
            }
            case 35: {
                node = new BetweenNode(true);
                break;
            }
            case 10: {
                node = new InNode(false);
                break;
            }
            case 36: {
                node = new InNode(true);
                break;
            }
            case 11: {
                node = new LikeNode((String)expression.getOperand(1), false, false);
                break;
            }
            case 37: {
                node = new LikeNode((String)expression.getOperand(1), true, false);
                break;
            }
            case 12: {
                node = new LikeNode((String)expression.getOperand(1), false, true);
                break;
            }
            case 38: {
                node = new LikeNode((String)expression.getOperand(1), true, true);
                break;
            }
            default: {
                throw new ExpressionException("Unsupported expression type: " + expression.getType() + " (" + expression.expName() + ")");
            }
        }
        return parent != null ? parent.wrapChildNode(node) : node;
    }

    private static boolean contains(Object[] objects, Object object) {
        int size = objects.length;
        for (int i = 0; i < size; ++i) {
            if (!Util.nullSafeEquals(objects[i], object)) continue;
            return true;
        }
        return false;
    }

    ASTNode wrapChildNode(ASTNode childNode) {
        return childNode;
    }

    ASTNode getNextNode() {
        return this.nextNode;
    }

    void setNextNode(ASTNode nextNode) {
        this.nextNode = nextNode;
    }

    abstract void appendString(StringBuffer var1);

    boolean evaluateBooleanASTChain(Object bean) throws ExpressionException {
        return ASTStack.booleanFromObject(this.evaluateASTChain(bean));
    }

    Object evaluateASTChain(Object bean) throws ExpressionException {
        ASTNode currentNode = this;
        ASTStack stack = new ASTStack();
        try {
            while ((currentNode = currentNode.evaluateWithObject(stack, bean)) != null) {
            }
            return stack.pop();
        }
        catch (Throwable th) {
            if (th instanceof ExpressionException) {
                throw (ExpressionException)th;
            }
            throw new ExpressionException("Error evaluating expression.", this.toString(), Util.unwindException(th));
        }
    }

    abstract ASTNode evaluateWithObject(ASTStack var1, Object var2);

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (ASTNode node = this; node != null; node = node.getNextNode()) {
            node.appendString(buffer);
        }
        return buffer.toString();
    }

    static final class OrOperandWrapper
    extends ConditionalJumpNode {
        OrOperandWrapper(ASTNode wrappedNode, ASTNode altNode) {
            super(wrappedNode, altNode);
        }

        boolean jumpPastAltNode(ASTStack stack) {
            return stack.peekBoolean();
        }
    }

    static final class AndOperandWrapper
    extends ConditionalJumpNode {
        AndOperandWrapper(ASTNode wrappedNode, ASTNode altNode) {
            super(wrappedNode, altNode);
        }

        boolean jumpPastAltNode(ASTStack stack) {
            return !stack.peekBoolean();
        }
    }

    static abstract class ConditionalJumpNode
    extends ASTNode {
        ASTNode wrappedNode;
        ASTNode altNode;

        ConditionalJumpNode(ASTNode wrappedNode, ASTNode altNode) {
            this.wrappedNode = wrappedNode;
            this.altNode = altNode;
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            ASTNode next = this.wrappedNode.evaluateWithObject(stack, bean);
            return this.jumpPastAltNode(stack) ? (this.altNode != null ? this.altNode.getNextNode() : null) : next;
        }

        ASTNode getNextNode() {
            return this.wrappedNode != null ? this.wrappedNode.getNextNode() : null;
        }

        void setNextNode(ASTNode nextNode) {
            if (this.wrappedNode != null) {
                this.wrappedNode.setNextNode(nextNode);
            }
        }

        void appendString(StringBuffer buffer) {
            buffer.append("(");
            if (this.wrappedNode != null) {
                this.wrappedNode.appendString(buffer);
            } else {
                buffer.append("?");
            }
            buffer.append(")");
        }

        abstract boolean jumpPastAltNode(ASTStack var1);
    }

    static final class LikeNode
    extends ASTNode {
        Pattern regex;
        boolean negate;

        LikeNode(String pattern, boolean negate, boolean ignoreCase) {
            this.regex = Util.sqlPatternToPattern(pattern, ignoreCase);
            this.negate = negate;
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            Object o = stack.pop();
            String string = o != null ? o.toString() : null;
            boolean match = this.regex.matcher(string).find();
            stack.push(this.negate ? !match : match);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            if (this.negate) {
                buffer.append(" NOT");
            }
            buffer.append(" LIKE ").append(this.regex);
        }
    }

    static final class InNode
    extends ASTNode {
        boolean negate;

        InNode(boolean negate) {
            this.negate = negate;
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            Object[] o1 = (Object[])stack.pop();
            Object o2 = stack.pop();
            boolean result = ASTNode.contains(o1, o2);
            stack.push(this.negate ? !result : result);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            if (this.negate) {
                buffer.append(" NOT");
            }
            buffer.append(" IN ");
        }
    }

    static final class BetweenNode
    extends ASTNode {
        boolean negate;

        BetweenNode(boolean negate) {
            this.negate = negate;
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            boolean result = false;
            Comparable c1 = stack.popComparable();
            Comparable c2 = stack.popComparable();
            Object c3 = stack.pop();
            if (c1 != null && c2 != null && c3 != null) {
                boolean bl = result = c2.compareTo(c3) <= 0 && c1.compareTo(c3) >= 0;
            }
            stack.push(this.negate ? !result : result);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            if (this.negate) {
                buffer.append(" NOT");
            }
            buffer.append(" BETWEEN ");
        }
    }

    static final class GreaterThanEqualsToNode
    extends ASTNode {
        GreaterThanEqualsToNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            boolean result = false;
            Object c1 = stack.pop();
            Comparable c2 = stack.popComparable();
            if (c1 != null && c2 != null) {
                result = c2.compareTo(c1) >= 0;
            }
            stack.push(result);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" >= ");
        }
    }

    static final class GreaterThanNode
    extends ASTNode {
        GreaterThanNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            boolean result = false;
            Object c1 = stack.pop();
            Comparable c2 = stack.popComparable();
            if (c1 != null && c2 != null) {
                result = c2.compareTo(c1) > 0;
            }
            stack.push(result);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" > ");
        }
    }

    static final class LessThanEqualsToNode
    extends ASTNode {
        LessThanEqualsToNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            boolean result = false;
            Object c1 = stack.pop();
            Comparable c2 = stack.popComparable();
            if (c1 != null && c2 != null) {
                result = c2.compareTo(c1) <= 0;
            }
            stack.push(result);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" <= ");
        }
    }

    static final class LessThanNode
    extends ASTNode {
        LessThanNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            boolean result = false;
            Object c1 = stack.pop();
            Comparable c2 = stack.popComparable();
            if (c1 != null && c2 != null) {
                result = c2.compareTo(c1) < 0;
            }
            stack.push(result);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" < ");
        }
    }

    static final class NotEqualsNode
    extends ASTNode {
        NotEqualsNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(!Util.nullSafeEquals(stack.pop(), stack.pop()));
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" != ");
        }
    }

    static final class NotNode
    extends ASTNode {
        NotNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(!stack.popBoolean());
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" not ");
        }
    }

    static final class OrNode
    extends ASTNode {
        OrNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(stack.popBoolean() || stack.popBoolean());
            return this.nextNode;
        }

        ASTNode wrapChildNode(ASTNode childNode) {
            return new OrOperandWrapper(childNode, this);
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" or ");
        }
    }

    static final class AndNode
    extends ASTNode {
        AndNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(stack.popBoolean() && stack.popBoolean());
            return this.nextNode;
        }

        ASTNode wrapChildNode(ASTNode childNode) {
            return new AndOperandWrapper(childNode, this);
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" and ");
        }
    }

    static final class EqualsNode
    extends ASTNode {
        EqualsNode() {
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(Util.nullSafeEquals(stack.pop(), stack.pop()));
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append(" = ");
        }
    }

    static final class PropertyNode
    extends ASTNode {
        Expression pathExp;
        String propertyPath;

        PropertyNode(Expression pathExp) {
            this.pathExp = pathExp;
            this.propertyPath = (String)pathExp.getOperand(0);
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            try {
                stack.push(bean instanceof DataObject ? ((DataObject)bean).readNestedProperty(this.propertyPath) : (bean instanceof Entity ? ((Entity)bean).resolvePathComponents(this.pathExp) : PropertyUtils.getProperty(bean, this.propertyPath)));
            }
            catch (Exception ex) {
                String beanClass = bean != null ? bean.getClass().getName() : "<null>";
                String msg = "Error reading property '" + beanClass + "." + this.propertyPath + "'.";
                throw new ExpressionException(msg, ex);
            }
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append("'").append(this.propertyPath).append("'");
        }
    }

    static final class ListNode
    extends ASTNode {
        Object[] value;

        ListNode(Object object) {
            this.value = object instanceof Collection ? ((Collection)object).toArray() : (object instanceof Object[] ? (Object[])object : new Object[]{object});
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(this.value);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append("(%@)");
        }
    }

    static final class PushNode
    extends ASTNode {
        Object value;

        PushNode(Object value) {
            this.value = value;
        }

        ASTNode evaluateWithObject(ASTStack stack, Object bean) {
            stack.push(this.value);
            return this.nextNode;
        }

        void appendString(StringBuffer buffer) {
            buffer.append("%@");
        }
    }
}

