/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.exp.BinaryExpression;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionException;
import org.objectstyle.cayenne.exp.ListExpression;
import org.objectstyle.cayenne.exp.TernaryExpression;
import org.objectstyle.cayenne.exp.UnaryExpression;
import org.objectstyle.cayenne.exp.parser.ASTAdd;
import org.objectstyle.cayenne.exp.parser.ASTAnd;
import org.objectstyle.cayenne.exp.parser.ASTBetween;
import org.objectstyle.cayenne.exp.parser.ASTDbPath;
import org.objectstyle.cayenne.exp.parser.ASTDivide;
import org.objectstyle.cayenne.exp.parser.ASTEqual;
import org.objectstyle.cayenne.exp.parser.ASTGreater;
import org.objectstyle.cayenne.exp.parser.ASTGreaterOrEqual;
import org.objectstyle.cayenne.exp.parser.ASTIn;
import org.objectstyle.cayenne.exp.parser.ASTLess;
import org.objectstyle.cayenne.exp.parser.ASTLessOrEqual;
import org.objectstyle.cayenne.exp.parser.ASTLike;
import org.objectstyle.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.objectstyle.cayenne.exp.parser.ASTList;
import org.objectstyle.cayenne.exp.parser.ASTMultiply;
import org.objectstyle.cayenne.exp.parser.ASTNegate;
import org.objectstyle.cayenne.exp.parser.ASTNot;
import org.objectstyle.cayenne.exp.parser.ASTNotBetween;
import org.objectstyle.cayenne.exp.parser.ASTNotEqual;
import org.objectstyle.cayenne.exp.parser.ASTNotIn;
import org.objectstyle.cayenne.exp.parser.ASTNotLike;
import org.objectstyle.cayenne.exp.parser.ASTNotLikeIgnoreCase;
import org.objectstyle.cayenne.exp.parser.ASTObjPath;
import org.objectstyle.cayenne.exp.parser.ASTOr;
import org.objectstyle.cayenne.exp.parser.ASTSubtract;
import org.objectstyle.cayenne.exp.parser.SimpleNode;

public class ExpressionFactory {
    private static Class[] typeLookup;

    public static Expression expressionOfType(int type) {
        if (type < 0 || type >= typeLookup.length) {
            throw new ExpressionException("Bad expression type: " + type);
        }
        if (typeLookup[type] == null) {
            throw new ExpressionException("Bad expression type: " + type);
        }
        if (SimpleNode.class.isAssignableFrom(typeLookup[type])) {
            try {
                return (Expression)typeLookup[type].newInstance();
            }
            catch (Exception ex) {
                throw new ExpressionException("Error creating expression", ex);
            }
        }
        if (BinaryExpression.class == typeLookup[type]) {
            return new BinaryExpression(type);
        }
        if (UnaryExpression.class == typeLookup[type]) {
            return new UnaryExpression(type);
        }
        if (TernaryExpression.class == typeLookup[type]) {
            return new TernaryExpression(type);
        }
        if (ListExpression.class == typeLookup[type]) {
            return new ListExpression(type);
        }
        throw new ExpressionException("Bad expression type: " + type);
    }

    protected static Object wrapPathOperand(Object op) {
        if (op instanceof Collection) {
            return new ASTList((Collection)op);
        }
        if (op instanceof Object[]) {
            return new ASTList((Object[])op);
        }
        return op;
    }

    public static Expression unaryExp(int type, Object operand) {
        Expression exp = ExpressionFactory.expressionOfType(type);
        exp.setOperand(0, operand);
        return exp;
    }

    public static Expression binaryExp(int type, Object leftOperand, Object rightOperand) {
        Expression exp = ExpressionFactory.expressionOfType(type);
        exp.setOperand(0, leftOperand);
        exp.setOperand(1, rightOperand);
        return exp;
    }

    public static Expression binaryPathExp(int type, String pathSpec, Object value) {
        return ExpressionFactory.binaryExp(type, ExpressionFactory.unaryExp(26, pathSpec), ExpressionFactory.wrapPathOperand(value));
    }

    public static Expression binaryDbPathExp(int type, String pathSpec, Object value) {
        return ExpressionFactory.binaryExp(type, ExpressionFactory.unaryExp(27, pathSpec), ExpressionFactory.wrapPathOperand(value));
    }

    public static Expression matchAnyDbExp(Map map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pairs.add(ExpressionFactory.binaryDbPathExp(pairType, (String)entry.getKey(), entry.getValue()));
        }
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression matchAllDbExp(Map map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pairs.add(ExpressionFactory.binaryDbPathExp(pairType, (String)entry.getKey(), entry.getValue()));
        }
        return ExpressionFactory.joinExp(0, pairs);
    }

    public static Expression matchAnyExp(Map map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pairs.add(ExpressionFactory.binaryPathExp(pairType, (String)entry.getKey(), entry.getValue()));
        }
        return ExpressionFactory.joinExp(1, pairs);
    }

    public static Expression matchAllExp(Map map, int pairType) {
        ArrayList<Expression> pairs = new ArrayList<Expression>();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            pairs.add(ExpressionFactory.binaryPathExp(pairType, (String)entry.getKey(), entry.getValue()));
        }
        return ExpressionFactory.joinExp(0, pairs);
    }

    public static Expression matchDbExp(String pathSpec, Object value) {
        return new ASTEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression noMatchDbExp(String pathSpec, Object value) {
        return new ASTNotEqual(new ASTDbPath(pathSpec), value);
    }

    public static Expression inDbExp(String pathSpec, Object[] values) {
        return new ASTIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression inDbExp(String pathSpec, Collection values) {
        return new ASTIn(new ASTDbPath(pathSpec), new ASTList(values));
    }

    public static Expression matchExp(String pathSpec, Object value) {
        return new ASTEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression noMatchExp(String pathSpec, Object value) {
        return new ASTNotEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessExp(String pathSpec, Object value) {
        return new ASTLess(new ASTObjPath(pathSpec), value);
    }

    public static Expression lessOrEqualExp(String pathSpec, Object value) {
        return new ASTLessOrEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression greaterExp(String pathSpec, Object value) {
        return new ASTGreater(new ASTObjPath(pathSpec), value);
    }

    public static Expression greaterOrEqualExp(String pathSpec, Object value) {
        return new ASTGreaterOrEqual(new ASTObjPath(pathSpec), value);
    }

    public static Expression inExp(String pathSpec, Object[] values) {
        return new ASTIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression inExp(String pathSpec, Collection values) {
        return new ASTIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression notInExp(String pathSpec, Collection values) {
        return new ASTNotIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression notInExp(String pathSpec, Object[] values) {
        return new ASTNotIn(new ASTObjPath(pathSpec), new ASTList(values));
    }

    public static Expression betweenExp(String pathSpec, Object value1, Object value2) {
        return new ASTBetween(new ASTObjPath(pathSpec), value1, value2);
    }

    public static Expression notBetweenExp(String pathSpec, Object value1, Object value2) {
        return new ASTNotBetween(new ASTObjPath(pathSpec), value1, value2);
    }

    public static Expression likeExp(String pathSpec, Object value) {
        return new ASTLike(new ASTObjPath(pathSpec), value);
    }

    public static Expression notLikeExp(String pathSpec, Object value) {
        return new ASTNotLike(new ASTObjPath(pathSpec), value);
    }

    public static Expression likeIgnoreCaseExp(String pathSpec, Object value) {
        return new ASTLikeIgnoreCase(new ASTObjPath(pathSpec), value);
    }

    public static Expression notLikeIgnoreCaseExp(String pathSpec, Object value) {
        return new ASTNotLikeIgnoreCase(new ASTObjPath(pathSpec), value);
    }

    public static Expression joinExp(int type, List expressions) {
        int len = expressions.size();
        if (len == 0) {
            return null;
        }
        Expression currentExp = (Expression)expressions.get(0);
        if (len == 1) {
            return currentExp;
        }
        Expression exp = ExpressionFactory.expressionOfType(type);
        for (int i = 0; i < len; ++i) {
            exp.setOperand(i, expressions.get(i));
        }
        return exp;
    }

    static {
        int[] allTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 31, 34, 33, 35, 36, 37, 38};
        int max = 0;
        int min = 0;
        int allLen = allTypes.length;
        for (int i = 0; i < allLen; ++i) {
            if (allTypes[i] > max) {
                max = allTypes[i];
                continue;
            }
            if (allTypes[i] >= min) continue;
            min = allTypes[i];
        }
        if (max > 500) {
            throw new RuntimeException("Types values are too big: " + max);
        }
        if (min < 0) {
            throw new RuntimeException("Types values are too small: " + min);
        }
        typeLookup = new Class[max + 1];
        ExpressionFactory.typeLookup[0] = ASTAnd.class;
        ExpressionFactory.typeLookup[1] = ASTOr.class;
        ExpressionFactory.typeLookup[9] = ASTBetween.class;
        ExpressionFactory.typeLookup[35] = ASTNotBetween.class;
        ExpressionFactory.typeLookup[3] = ASTEqual.class;
        ExpressionFactory.typeLookup[4] = ASTNotEqual.class;
        ExpressionFactory.typeLookup[5] = ASTLess.class;
        ExpressionFactory.typeLookup[6] = ASTGreater.class;
        ExpressionFactory.typeLookup[7] = ASTLessOrEqual.class;
        ExpressionFactory.typeLookup[8] = ASTGreaterOrEqual.class;
        ExpressionFactory.typeLookup[10] = ASTIn.class;
        ExpressionFactory.typeLookup[36] = ASTNotIn.class;
        ExpressionFactory.typeLookup[11] = ASTLike.class;
        ExpressionFactory.typeLookup[12] = ASTLikeIgnoreCase.class;
        ExpressionFactory.typeLookup[37] = ASTNotLike.class;
        ExpressionFactory.typeLookup[38] = ASTNotLikeIgnoreCase.class;
        ExpressionFactory.typeLookup[16] = ASTAdd.class;
        ExpressionFactory.typeLookup[17] = ASTSubtract.class;
        ExpressionFactory.typeLookup[18] = ASTMultiply.class;
        ExpressionFactory.typeLookup[19] = ASTDivide.class;
        ExpressionFactory.typeLookup[2] = ASTNot.class;
        ExpressionFactory.typeLookup[20] = ASTNegate.class;
        ExpressionFactory.typeLookup[26] = ASTObjPath.class;
        ExpressionFactory.typeLookup[27] = ASTDbPath.class;
        ExpressionFactory.typeLookup[28] = ASTList.class;
        ExpressionFactory.typeLookup[15] = UnaryExpression.class;
        ExpressionFactory.typeLookup[21] = UnaryExpression.class;
        ExpressionFactory.typeLookup[22] = UnaryExpression.class;
        ExpressionFactory.typeLookup[23] = UnaryExpression.class;
        ExpressionFactory.typeLookup[24] = UnaryExpression.class;
        ExpressionFactory.typeLookup[25] = UnaryExpression.class;
        ExpressionFactory.typeLookup[29] = UnaryExpression.class;
        ExpressionFactory.typeLookup[32] = UnaryExpression.class;
        ExpressionFactory.typeLookup[31] = UnaryExpression.class;
        ExpressionFactory.typeLookup[30] = UnaryExpression.class;
        ExpressionFactory.typeLookup[34] = UnaryExpression.class;
        ExpressionFactory.typeLookup[33] = UnaryExpression.class;
    }
}

