/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.event.EventSubject;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbJoin;
import org.objectstyle.cayenne.map.Entity;
import org.objectstyle.cayenne.map.Relationship;
import org.objectstyle.cayenne.map.event.RelationshipEvent;
import org.objectstyle.cayenne.util.Util;
import org.objectstyle.cayenne.util.XMLEncoder;

public class DbRelationship
extends Relationship {
    public static final EventSubject PROPERTY_DID_CHANGE = EventSubject.getSubject(DbRelationship.class, "PropertyDidChange");
    protected List joins = new ArrayList();
    protected boolean toDependentPK;

    public DbRelationship() {
    }

    public DbRelationship(String name) {
        super(name);
    }

    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<db-relationship name=\"");
        encoder.print(Util.encodeXmlAttribute(this.getName()));
        encoder.print("\" source=\"");
        encoder.print(this.getSourceEntity().getName());
        if (this.getTargetEntityName() != null && this.getTargetEntity() != null) {
            encoder.print("\" target=\"");
            encoder.print(this.getTargetEntityName());
        }
        if (this.isToDependentPK() && this.isValidForDepPk()) {
            encoder.print("\" toDependentPK=\"true");
        }
        encoder.print("\" toMany=\"");
        encoder.print(this.isToMany());
        encoder.println("\">");
        encoder.indent(1);
        encoder.print(this.getJoins());
        encoder.indent(-1);
        encoder.println("</db-relationship>");
    }

    public Entity getTargetEntity() {
        String targetName = this.getTargetEntityName();
        if (targetName == null) {
            return null;
        }
        return this.getNonNullNamespace().getDbEntity(targetName);
    }

    public Collection getTargetAttributes() {
        if (this.joins.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return CollectionUtils.collect(this.joins, JoinTransformers.targetExtractor);
    }

    public Collection getSourceAttributes() {
        if (this.joins.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return CollectionUtils.collect(this.joins, JoinTransformers.sourceExtractor);
    }

    public DbRelationship createReverseRelationship() {
        DbRelationship reverse = new DbRelationship();
        reverse.setSourceEntity(this.getTargetEntity());
        reverse.setTargetEntityName(this.getSourceEntity().getName());
        reverse.setToMany(!this.toMany);
        Iterator it = this.joins.iterator();
        while (it.hasNext()) {
            DbJoin join = (DbJoin)it.next();
            DbJoin reverseJoin = join.createReverseJoin();
            reverseJoin.setRelationship(reverse);
            reverse.addJoin(reverseJoin);
        }
        return reverse;
    }

    public DbRelationship getReverseRelationship() {
        Entity target = this.getTargetEntity();
        if (target == null) {
            return null;
        }
        Entity src = this.getSourceEntity();
        if (target == src && this.joins.size() == 0) {
            return null;
        }
        TestJoin testJoin = new TestJoin(this);
        Iterator it = target.getRelationships().iterator();
        while (it.hasNext()) {
            List otherJoins;
            DbRelationship rel = (DbRelationship)it.next();
            if (rel.getTargetEntity() != src || (otherJoins = rel.getJoins()).size() != this.joins.size()) continue;
            Iterator jit = otherJoins.iterator();
            boolean joinsMatch = true;
            while (jit.hasNext()) {
                DbJoin join = (DbJoin)jit.next();
                testJoin.setSourceName(join.getTargetName());
                testJoin.setTargetName(join.getSourceName());
                if (this.joins.contains(testJoin)) continue;
                joinsMatch = false;
                break;
            }
            if (!joinsMatch) continue;
            return rel;
        }
        return null;
    }

    public boolean isToPK() {
        Iterator it = this.getJoins().iterator();
        while (it.hasNext()) {
            DbJoin join = (DbJoin)it.next();
            if (join.getTarget() == null) {
                return false;
            }
            if (!join.getTarget().isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public boolean isToMasterPK() {
        if (this.isToMany() || this.isToDependentPK()) {
            return false;
        }
        DbRelationship revRel = this.getReverseRelationship();
        return revRel != null ? revRel.isToDependentPK() : false;
    }

    public boolean isToDependentPK() {
        return this.toDependentPK;
    }

    public void setToDependentPK(boolean flag) {
        this.toDependentPK = flag;
    }

    public boolean isValidForDepPk() {
        Iterator it = this.getJoins().iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            DbJoin join = (DbJoin)it.next();
            DbAttribute target = join.getTarget();
            DbAttribute source = join.getSource();
            if ((target == null || target.isPrimaryKey()) && (source == null || source.isPrimaryKey())) continue;
            return false;
        }
        return true;
    }

    public List getJoins() {
        return this.joins;
    }

    public void addJoin(DbJoin join) {
        if (join != null) {
            this.joins.add(join);
        }
    }

    public void removeJoin(DbJoin join) {
        this.joins.remove(join);
    }

    public void removeAllJoins() {
        this.joins.clear();
    }

    public void setJoins(Collection newJoins) {
        this.removeAllJoins();
        if (newJoins != null) {
            this.joins.addAll(newJoins);
        }
    }

    public Map targetPkSnapshotWithSrcSnapshot(Map srcSnapshot) {
        Map idMap;
        if (this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' relationships support this method.");
        }
        int numJoins = this.joins.size();
        int foundNulls = 0;
        if (numJoins == 1) {
            DbJoin join = (DbJoin)this.joins.get(0);
            Object val = srcSnapshot.get(join.getSourceName());
            if (val == null) {
                ++foundNulls;
                idMap = Collections.EMPTY_MAP;
            } else {
                idMap = Collections.singletonMap(join.getTargetName(), val);
            }
        } else {
            idMap = new HashMap(numJoins * 2);
            for (int i = 0; i < numJoins; ++i) {
                DbJoin join = (DbJoin)this.joins.get(i);
                DbAttribute source = join.getSource();
                Object val = srcSnapshot.get(join.getSourceName());
                if (val == null) {
                    if (!source.isMandatory()) {
                        return null;
                    }
                    ++foundNulls;
                    continue;
                }
                idMap.put(join.getTargetName(), val);
            }
        }
        if (foundNulls == 0) {
            return idMap;
        }
        if (foundNulls == numJoins) {
            return null;
        }
        throw new CayenneRuntimeException("Some parts of FK are missing in snapshot, relationship: " + this);
    }

    private Map srcSnapshotWithTargetSnapshot(Map targetSnapshot) {
        int len = this.joins.size();
        if (len == 1) {
            DbJoin join = (DbJoin)this.joins.get(0);
            Object val = targetSnapshot.get(join.getTargetName());
            return Collections.singletonMap(join.getSourceName(), val);
        }
        HashMap idMap = new HashMap(len * 2);
        for (int i = 0; i < len; ++i) {
            DbJoin join = (DbJoin)this.joins.get(i);
            Object val = targetSnapshot.get(join.getTargetName());
            idMap.put(join.getSourceName(), val);
        }
        return idMap;
    }

    public Map srcFkSnapshotWithTargetSnapshot(Map targetSnapshot) {
        if (this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' relationships support this method.");
        }
        return this.srcSnapshotWithTargetSnapshot(targetSnapshot);
    }

    public Map srcPkSnapshotWithTargetSnapshot(Map targetSnapshot) {
        if (!this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to many' relationships support this method.");
        }
        return this.srcSnapshotWithTargetSnapshot(targetSnapshot);
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
        this.firePropertyDidChange();
    }

    protected void firePropertyDidChange() {
        RelationshipEvent event = new RelationshipEvent((Object)this, this, this.getSourceEntity());
        EventManager.getDefaultManager().postEvent(event, PROPERTY_DID_CHANGE);
    }

    static final class TestJoin
    extends DbJoin {
        TestJoin(DbRelationship relationship) {
            super(relationship);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof DbJoin)) {
                return false;
            }
            DbJoin j = (DbJoin)o;
            return j.relationship == this.relationship && Util.nullSafeEquals(j.sourceName, this.sourceName) && Util.nullSafeEquals(j.targetName, this.targetName);
        }
    }

    static final class JoinTransformers {
        static final Transformer targetExtractor = new Transformer(){

            public Object transform(Object input) {
                return input instanceof DbJoin ? ((DbJoin)input).getTarget() : input;
            }
        };
        static final Transformer sourceExtractor = new Transformer(){

            public Object transform(Object input) {
                return input instanceof DbJoin ? ((DbJoin)input).getSource() : input;
            }
        };

        JoinTransformers() {
        }
    }
}

