/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.access.ClientServerChannel;
import org.objectstyle.cayenne.access.DataDomain;
import org.objectstyle.cayenne.conf.Configuration;
import org.objectstyle.cayenne.conf.DefaultConfiguration;
import org.objectstyle.cayenne.opp.DispatchHelper;
import org.objectstyle.cayenne.opp.OPPMessage;
import org.objectstyle.cayenne.opp.OPPRemoteService;
import org.objectstyle.cayenne.opp.OPPRemoteSession;
import org.objectstyle.cayenne.util.IDUtil;
import org.objectstyle.cayenne.util.Util;

public class BaseRemoteService
implements OPPRemoteService {
    private static final Logger logObj = Logger.getLogger(BaseRemoteService.class);
    public static final String EVENT_BRIDGE_FACTORY_PROPERTY = "cayenne.OPPRemoteService.EventBridge.factory";
    protected Map sessionChannels;
    protected Map sharedSessions;
    protected DataDomain domain;
    protected String eventBridgeFactoryName;
    protected Map eventBridgeParameters;

    public String getEventBridgeFactoryName() {
        return this.eventBridgeFactoryName;
    }

    public Map getEventBridgeParameters() {
        return this.eventBridgeParameters != null ? Collections.unmodifiableMap(this.eventBridgeParameters) : Collections.EMPTY_MAP;
    }

    protected void initService(Map properties) throws CayenneRuntimeException {
        logObj.debug(this.getClass().getName() + " is starting");
        this.initCayenneStack(properties);
        this.initEventBridgeParameters(properties);
        this.sessionChannels = new HashMap();
        this.sharedSessions = new HashMap();
        logObj.debug(this.getClass().getName() + " started");
    }

    protected void destroyService() {
        this.sessionChannels = null;
        this.sharedSessions = null;
        logObj.debug(this.getClass().getName() + " destroyed");
    }

    public OPPRemoteSession establishSession() {
        logObj.debug("Session requested by client");
        OPPRemoteSession session = this.createSession(false);
        logObj.debug("Established client session: " + session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPPRemoteSession establishSharedSession(String name) {
        OPPRemoteSession session;
        logObj.debug("Shared session requested by client. Group name: " + name);
        if (name == null) {
            throw new CayenneRuntimeException("Invalid shared session name: " + name);
        }
        Map map = this.sessionChannels;
        synchronized (map) {
            session = (OPPRemoteSession)this.sharedSessions.get(name);
            if (session == null || this.sessionChannels.get(session.getSessionId()) == null) {
                session = this.createSession(true);
                session.setName(name);
                logObj.debug("Created new shared session:" + session);
            } else {
                logObj.debug("Found existing shared session:" + session);
            }
            this.sharedSessions.put(name, session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processMessage(String sessionId, OPPMessage message) throws Throwable {
        DataChannel handler;
        logObj.debug("processMessage, sessionId: " + sessionId);
        Map map = this.sessionChannels;
        synchronized (map) {
            handler = (DataChannel)this.sessionChannels.get(sessionId);
        }
        if (handler == null) {
            throw new CayenneRuntimeException("Invalid sessionId: " + sessionId);
        }
        try {
            return DispatchHelper.dispatch(handler, message);
        }
        catch (Throwable th) {
            th = Util.unwindException(th);
            logObj.info("error processing message", th);
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OPPRemoteSession createSession(boolean enableEvents) {
        String id = this.makeId();
        OPPRemoteSession session = enableEvents ? new OPPRemoteSession(id, this.eventBridgeFactoryName, this.eventBridgeParameters) : new OPPRemoteSession(id);
        ClientServerChannel channel = new ClientServerChannel(this.domain, false);
        Map map = this.sessionChannels;
        synchronized (map) {
            this.sessionChannels.put(session.getSessionId(), channel);
        }
        return session;
    }

    String makeId() {
        byte[] bytes = IDUtil.pseudoUniqueSecureByteSequence(32);
        String digits = "0123456789ABCDEF";
        StringBuffer buffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buffer.append("0123456789ABCDEF".charAt(b >>> 4 & 0xF));
            buffer.append("0123456789ABCDEF".charAt(b & 0xF));
        }
        return buffer.toString();
    }

    protected void initCayenneStack(Map properties) {
        DefaultConfiguration cayenneConfig = new DefaultConfiguration("cayenne.xml");
        try {
            ((Configuration)cayenneConfig).initialize();
            ((Configuration)cayenneConfig).didInitialize();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error starting Cayenne", ex);
        }
        this.domain = cayenneConfig.getDomain();
    }

    protected void initEventBridgeParameters(Map properties) {
        String eventBridgeFactoryName = (String)properties.get(EVENT_BRIDGE_FACTORY_PROPERTY);
        if (eventBridgeFactoryName != null) {
            HashMap eventBridgeParameters = new HashMap(properties);
            eventBridgeParameters.remove(EVENT_BRIDGE_FACTORY_PROPERTY);
            this.eventBridgeFactoryName = eventBridgeFactoryName;
            this.eventBridgeParameters = eventBridgeParameters;
        }
    }
}

