/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.DataChannel;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.QueryResponse;
import org.objectstyle.cayenne.event.EventBridge;
import org.objectstyle.cayenne.event.EventManager;
import org.objectstyle.cayenne.event.EventSubject;
import org.objectstyle.cayenne.graph.CompoundDiff;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.graph.GraphEvent;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.opp.BootstrapMessage;
import org.objectstyle.cayenne.opp.OPPConnection;
import org.objectstyle.cayenne.opp.OPPMessage;
import org.objectstyle.cayenne.opp.QueryMessage;
import org.objectstyle.cayenne.opp.SyncMessage;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.util.DeepMergeOperation;
import org.objectstyle.cayenne.util.GenericResponse;

public class OPPServerChannel
implements DataChannel {
    private static final Log logger = LogFactory.getLog(OPPServerChannel.class);
    protected OPPConnection connection;
    protected EventManager eventManager;
    protected boolean channelEventsEnabled;
    EventBridge remoteChannelListener;

    public OPPServerChannel(OPPConnection connection) {
        this(connection, false);
    }

    public OPPServerChannel(OPPConnection connection, boolean channelEventsEnabled) {
        this(connection, channelEventsEnabled, new EventManager(2));
    }

    public OPPServerChannel(OPPConnection connection, boolean channelEventsEnabled, EventManager eventManager) throws CayenneRuntimeException {
        this.connection = connection;
        this.eventManager = eventManager;
        this.channelEventsEnabled = eventManager != null && channelEventsEnabled;
        this.setupRemoteChannelListener();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public QueryResponse onQuery(ObjectContext context, Query query) {
        EntityResolver resolver;
        QueryMetadata info;
        QueryResponse response = (QueryResponse)this.send(new QueryMessage(query), QueryResponse.class);
        if (context != null && !(info = query.getMetaData(resolver = context.getEntityResolver())).isFetchingDataRows()) {
            GenericResponse childResponse = new GenericResponse();
            response.reset();
            while (response.next()) {
                if (response.isList()) {
                    List objects = response.currentList();
                    if (objects.isEmpty()) {
                        childResponse.addResultList(objects);
                        continue;
                    }
                    ArrayList<Object> childObjects = new ArrayList<Object>(objects.size());
                    DeepMergeOperation merger = new DeepMergeOperation(context);
                    Iterator it = objects.iterator();
                    while (it.hasNext()) {
                        Persistent object = (Persistent)it.next();
                        ObjectId id = object.getObjectId();
                        if (id == null) {
                            throw new CayenneRuntimeException("Server returned an object without an id: " + object);
                        }
                        ClassDescriptor descriptor = resolver.getClassDescriptor(id.getEntityName());
                        childObjects.add(merger.merge(object, descriptor));
                    }
                    childResponse.addResultList(childObjects);
                    continue;
                }
                childResponse.addBatchUpdateCount(response.currentUpdateCount());
            }
            response = childResponse;
        }
        return response;
    }

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        GraphDiff replyDiff = (GraphDiff)this.send(new SyncMessage(originatingContext, syncType, changes), GraphDiff.class);
        if (this.channelEventsEnabled) {
            EventSubject subject;
            switch (syncType) {
                case 3: {
                    subject = DataChannel.GRAPH_ROLLEDBACK_SUBJECT;
                    break;
                }
                case 1: {
                    subject = DataChannel.GRAPH_CHANGED_SUBJECT;
                    break;
                }
                case 2: {
                    subject = DataChannel.GRAPH_COMMITTED_SUBJECT;
                    break;
                }
                default: {
                    subject = null;
                }
            }
            if (subject != null) {
                boolean receivedNoop;
                boolean sentNoop = changes == null || changes.isNoop();
                boolean bl = receivedNoop = replyDiff == null || replyDiff.isNoop();
                if (!sentNoop || !receivedNoop) {
                    CompoundDiff notification = new CompoundDiff();
                    if (!sentNoop) {
                        notification.add(changes);
                    }
                    if (!receivedNoop) {
                        notification.add(replyDiff);
                    }
                    Object eventSource = originatingContext != null ? originatingContext : this;
                    GraphEvent e = new GraphEvent(eventSource, notification);
                    e.setPostedBy(this);
                    this.eventManager.postEvent(e, subject);
                }
            }
        }
        return replyDiff;
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)this.send(new BootstrapMessage(), EntityResolver.class);
    }

    protected boolean setupRemoteChannelListener() throws CayenneRuntimeException {
        if (this.eventManager == null) {
            logger.info("Channel has no EventManager, won't install EventBridge.");
            return false;
        }
        EventBridge bridge = this.connection.getServerEventBridge();
        if (bridge == null) {
            logger.info("Remote service doesn't support channel events.");
            return false;
        }
        try {
            bridge.startup(this.eventManager, 3, null, this);
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error starting EventBridge " + bridge, e);
        }
        this.remoteChannelListener = bridge;
        return true;
    }

    protected Object send(OPPMessage message, Class resultClass) {
        Object result = this.connection.sendMessage(message);
        if (result != null && !resultClass.isInstance(result)) {
            String resultString = new ToStringBuilder(result).toString();
            throw new CayenneRuntimeException("Expected result type: " + resultClass.getName() + ", actual: " + resultString);
        }
        return result;
    }
}

