/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp;

import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.graph.GraphDiff;
import org.objectstyle.cayenne.opp.OPPMessage;

public class SyncMessage
implements OPPMessage {
    protected transient ObjectContext source;
    protected int type;
    protected GraphDiff senderChanges;

    private SyncMessage() {
    }

    public SyncMessage(ObjectContext source, int syncType, GraphDiff senderChanges) {
        if (syncType != 1 && syncType != 2 && syncType != 3) {
            throw new IllegalArgumentException("'type' is invalid: " + syncType);
        }
        this.source = source;
        this.type = syncType;
        this.senderChanges = senderChanges;
    }

    public ObjectContext getSource() {
        return this.source;
    }

    public int getType() {
        return this.type;
    }

    public GraphDiff getSenderChanges() {
        return this.senderChanges;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "flush-sync";
            }
            case 2: {
                return "flush-cascade-sync";
            }
            case 3: {
                return "rollback-cascade-sync";
            }
        }
        return "unknown-sync";
    }
}

