/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.opp.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.objectstyle.cayenne.util.Util;

public final class HessianUtil {
    private static AbstractSerializerFactory extendedSerializer;

    public static Object cloneViaHessianSerialization(Serializable object) throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        HessianOutput out = new HessianOutput((OutputStream)bytes);
        HessianUtil.configExtensions(out.getSerializerFactory());
        out.writeObject((Object)object);
        byte[] data = bytes.toByteArray();
        HessianInput in = new HessianInput((InputStream)new ByteArrayInputStream(data));
        HessianUtil.configExtensions(in.getSerializerFactory());
        return in.readObject();
    }

    static void configExtensions(SerializerFactory factory) {
        if (extendedSerializer != null) {
            factory.addFactory(extendedSerializer);
        }
    }

    private HessianUtil() {
    }

    static {
        try {
            Class.forName("java.lang.StringBuilder");
            Class factoryClass = Util.getJavaClass("org.objectstyle.cayenne.opp.hessian.EnumSerializerFactory");
            extendedSerializer = (AbstractSerializerFactory)factoryClass.newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

