/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project;

import java.util.Arrays;

public class ProjectPath {
    public static final Object[] EMPTY_PATH = new Object[0];
    protected Object[] path;

    public ProjectPath() {
        this.path = EMPTY_PATH;
    }

    public ProjectPath(Object object) {
        this.path = new Object[]{object};
    }

    public ProjectPath(Object[] path) {
        this.path = path != null ? path : EMPTY_PATH;
    }

    public Object[] getPath() {
        return this.path;
    }

    public boolean isEmpty() {
        return this.path == null || this.path.length == 0;
    }

    public Object firstInstanceOf(Class aClass) {
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i] == null || !aClass.isAssignableFrom(this.path[i].getClass())) continue;
            return this.path[i];
        }
        return null;
    }

    public ProjectPath appendToPath(Object object) {
        if (object != null) {
            Object[] newPath = new Object[this.path.length + 1];
            if (this.path.length > 0) {
                System.arraycopy(this.path, 0, newPath, 0, this.path.length);
            }
            newPath[this.path.length] = object;
            return new ProjectPath(newPath);
        }
        return this;
    }

    public ProjectPath subpathWithSize(int subpathSize) {
        if (subpathSize <= 0) {
            return new ProjectPath();
        }
        if (subpathSize == this.path.length) {
            return this;
        }
        if (subpathSize > this.path.length) {
            throw new ArrayIndexOutOfBoundsException("Subpath is longer than this path " + subpathSize + " components. Path size: " + this.path.length);
        }
        Object[] newPath = new Object[subpathSize];
        System.arraycopy(this.path, 0, newPath, 0, subpathSize);
        return new ProjectPath(newPath);
    }

    public ProjectPath subpathOfObject(Object object) {
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i] != object) continue;
            return this.subpathWithSize(i + 1);
        }
        return null;
    }

    public Object getRoot() {
        if (this.path.length == 0) {
            return null;
        }
        return this.path[0];
    }

    public Object getObject() {
        if (this.path.length == 0) {
            return null;
        }
        return this.path[this.path.length - 1];
    }

    public Object getObjectParent() {
        if (this.path.length == 0) {
            return null;
        }
        return this.path.length > 1 ? this.path[this.path.length - 2] : null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ProjectPath: ");
        for (int i = 0; i < this.path.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            String token = this.path[i] != null ? this.path[i].getClass().getName() : "<null>";
            buf.append(token);
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProjectPath)) {
            return false;
        }
        ProjectPath otherPath = (ProjectPath)object;
        return Arrays.equals(this.getPath(), otherPath.getPath());
    }
}

