/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.project.validator;

import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DerivedDbAttribute;
import org.objectstyle.cayenne.project.ProjectPath;
import org.objectstyle.cayenne.project.validator.MappingNamesHelper;
import org.objectstyle.cayenne.project.validator.TreeNodeValidator;
import org.objectstyle.cayenne.project.validator.Validator;
import org.objectstyle.cayenne.util.Util;

public class DbAttributeValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        DbAttribute attribute = (DbAttribute)path.getObject();
        if (Util.isEmptyString(attribute.getName())) {
            validator.registerError("Unnamed DbAttribute.", path);
        } else {
            MappingNamesHelper helper = MappingNamesHelper.getInstance();
            String invalidChars = helper.invalidCharsInDbPathComponent(attribute.getName());
            if (invalidChars != null) {
                validator.registerWarning("DbAttribute name contains invalid characters: " + invalidChars, path);
            }
        }
        if (attribute.getType() == Integer.MAX_VALUE) {
            validator.registerWarning("DbAttribute has no type.", path);
        }
        if (attribute instanceof DerivedDbAttribute) {
            DerivedDbAttribute derived = (DerivedDbAttribute)attribute;
            int paramCount = derived.getParams().size();
            String spec = derived.getExpressionSpec();
            int paramsExpected = 0;
            if (spec != null) {
                int ind = -"%@".length();
                while ((ind = spec.indexOf("%@", ind + "%@".length())) >= 0) {
                    ++paramsExpected;
                }
            }
            if (paramsExpected != paramCount) {
                validator.registerWarning("Derived Attribute's \"" + attribute.getName() + "\" parameter mismatch.", path);
            }
        } else if (attribute.getMaxLength() < 0 && (attribute.getType() == 12 || attribute.getType() == 1)) {
            validator.registerWarning("Character DbAttribute doesn't have max length.", path);
        }
    }
}

