/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.objectstyle.cayenne.map.DbAttribute;
import org.objectstyle.cayenne.map.DbEntity;
import org.objectstyle.cayenne.query.BatchQuery;

public class DeleteBatchQuery
extends BatchQuery {
    protected List qualifierSnapshots;
    protected List dbAttributes;
    protected boolean usingOptimisticLocking;
    private List qualifierAttributes;
    private Collection nullQualifierNames;

    public DeleteBatchQuery(DbEntity dbEntity, int batchCapacity) {
        this(dbEntity, dbEntity.getPrimaryKey(), Collections.EMPTY_SET, batchCapacity);
    }

    public DeleteBatchQuery(DbEntity dbEntity, List qualifierAttributes, Collection nullQualifierNames, int batchCapacity) {
        super(dbEntity);
        this.qualifierAttributes = qualifierAttributes;
        this.nullQualifierNames = nullQualifierNames != null ? nullQualifierNames : Collections.EMPTY_SET;
        this.qualifierSnapshots = new ArrayList(batchCapacity);
        this.dbAttributes = new ArrayList(qualifierAttributes.size());
        this.dbAttributes.addAll(qualifierAttributes);
        this.batchIndex = -1;
    }

    public boolean isNull(DbAttribute attribute) {
        return this.nullQualifierNames.contains(attribute.getName());
    }

    public boolean isUsingOptimisticLocking() {
        return this.usingOptimisticLocking;
    }

    public void setUsingOptimisticLocking(boolean usingOptimisticLocking) {
        this.usingOptimisticLocking = usingOptimisticLocking;
    }

    public List getQualifierAttributes() {
        return Collections.unmodifiableList(this.qualifierAttributes);
    }

    public Object getValue(int dbAttributeIndex) {
        DbAttribute attribute = (DbAttribute)this.dbAttributes.get(dbAttributeIndex);
        return this.getCurrentQualifier().get(attribute.getName());
    }

    public void add(Map dataObjectId) {
        this.qualifierSnapshots.add(dataObjectId);
    }

    public int size() {
        return this.qualifierSnapshots.size();
    }

    public List getDbAttributes() {
        return this.dbAttributes;
    }

    public Map getCurrentQualifier() {
        return (Map)this.qualifierSnapshots.get(this.batchIndex);
    }
}

