/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.query;

import org.apache.commons.lang.StringUtils;
import org.objectstyle.cayenne.CayenneRuntimeException;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.exp.Expression;
import org.objectstyle.cayenne.exp.ExpressionFactory;
import org.objectstyle.cayenne.map.EntityResolver;
import org.objectstyle.cayenne.map.ObjEntity;
import org.objectstyle.cayenne.map.ObjRelationship;
import org.objectstyle.cayenne.query.DefaultQueryMetadata;
import org.objectstyle.cayenne.query.IndirectQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.SelectQuery;

public class RelationshipQuery
extends IndirectQuery {
    protected ObjectId objectId;
    protected String relationshipName;
    protected boolean refreshing;

    private RelationshipQuery() {
    }

    public RelationshipQuery(ObjectId objectID, String relationshipName) {
        this(objectID, relationshipName, true);
    }

    public RelationshipQuery(ObjectId objectID, String relationshipName, boolean refreshing) {
        if (objectID == null) {
            throw new CayenneRuntimeException("Null objectID");
        }
        if (objectID.isTemporary()) {
            throw new CayenneRuntimeException("Temporary id can't be used in RelationshipQuery: " + objectID);
        }
        this.objectId = objectID;
        this.relationshipName = relationshipName;
        this.refreshing = refreshing;
    }

    public QueryMetadata getMetaData(final EntityResolver resolver) {
        return new DefaultQueryMetadata(){

            public boolean isRefreshingObjects() {
                return RelationshipQuery.this.refreshing;
            }

            public ObjEntity getObjEntity() {
                return (ObjEntity)RelationshipQuery.this.getRelationship(resolver).getTargetEntity();
            }
        };
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    protected Query createReplacementQuery(EntityResolver resolver) {
        if (this.objectId.isTemporary() && !this.objectId.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for relationship '" + this.relationshipName + "' for temporary id: " + this.objectId);
        }
        ObjRelationship relationship = this.getRelationship(resolver);
        Expression qualifier = ExpressionFactory.matchDbExp(relationship.getReverseDbRelationshipPath(), this.objectId);
        SelectQuery query = new SelectQuery((ObjEntity)relationship.getTargetEntity(), qualifier);
        query.setRefreshingObjects(this.refreshing);
        return query;
    }

    public ObjRelationship getRelationship(EntityResolver resolver) {
        if (this.objectId == null) {
            throw new CayenneRuntimeException("Can't resolve query - objectID is null.");
        }
        ObjEntity entity = resolver.lookupObjEntity(this.objectId.getEntityName());
        ObjRelationship relationship = (ObjRelationship)entity.getRelationship(this.relationshipName);
        if (relationship == null) {
            throw new CayenneRuntimeException("No relationship named " + this.relationshipName + " found in entity " + entity.getName() + "; object id: " + this.objectId);
        }
        return relationship;
    }

    public String toString() {
        return StringUtils.substringAfterLast(this.getClass().getName(), ".") + ":" + this.getRelationshipName();
    }
}

