/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.cayenne.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectstyle.cayenne.Fault;
import org.objectstyle.cayenne.ObjectContext;
import org.objectstyle.cayenne.ObjectId;
import org.objectstyle.cayenne.Persistent;
import org.objectstyle.cayenne.QueryResponse;
import org.objectstyle.cayenne.property.ClassDescriptor;
import org.objectstyle.cayenne.query.ObjectIdQuery;
import org.objectstyle.cayenne.query.Query;
import org.objectstyle.cayenne.query.QueryMetadata;
import org.objectstyle.cayenne.query.RelationshipQuery;
import org.objectstyle.cayenne.util.GenericResponse;
import org.objectstyle.cayenne.util.ListResponse;

public class ObjectContextQueryAction {
    protected static final boolean DONE = true;
    protected ObjectContext targetContext;
    protected ObjectContext actingContext;
    protected Query query;
    protected QueryMetadata metadata;
    protected transient QueryResponse response;

    public ObjectContextQueryAction(ObjectContext actingContext, ObjectContext targetContext, Query query) {
        this.actingContext = actingContext;
        this.query = query;
        this.targetContext = targetContext != actingContext ? targetContext : null;
        this.metadata = query.getMetaData(actingContext.getEntityResolver());
    }

    public QueryResponse execute() {
        if (!this.interceptOIDQuery() && !this.interceptRelationshipQuery()) {
            this.runQuery();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    protected void interceptObjectConversion() {
        if (this.targetContext != null && !this.metadata.isFetchingDataRows()) {
            GenericResponse childResponse = new GenericResponse();
            this.response.reset();
            while (this.response.next()) {
                if (this.response.isList()) {
                    List objects = this.response.currentList();
                    if (objects.isEmpty()) {
                        childResponse.addResultList(objects);
                        continue;
                    }
                    ArrayList<Persistent> childObjects = new ArrayList<Persistent>(objects.size());
                    Iterator it = objects.iterator();
                    while (it.hasNext()) {
                        Persistent object = (Persistent)it.next();
                        childObjects.add(this.targetContext.localObject(object.getObjectId(), object));
                    }
                    childResponse.addResultList(childObjects);
                    continue;
                }
                childResponse.addBatchUpdateCount(this.response.currentUpdateCount());
            }
            this.response = childResponse;
        }
    }

    protected boolean interceptOIDQuery() {
        Object object;
        ObjectIdQuery oidQuery;
        if (this.query instanceof ObjectIdQuery && !(oidQuery = (ObjectIdQuery)this.query).isFetchMandatory() && !oidQuery.isFetchingDataRows() && (object = this.actingContext.getGraphManager().getNode(oidQuery.getObjectId())) != null) {
            this.response = new ListResponse(object);
            return true;
        }
        return false;
    }

    protected boolean interceptRelationshipQuery() {
        RelationshipQuery relationshipQuery;
        if (this.query instanceof RelationshipQuery && !(relationshipQuery = (RelationshipQuery)this.query).isRefreshing()) {
            Object related;
            ClassDescriptor descriptor;
            if (this.targetContext == null && relationshipQuery.getRelationship(this.actingContext.getEntityResolver()).isToMany()) {
                return false;
            }
            ObjectId id = relationshipQuery.getObjectId();
            Object object = this.actingContext.getGraphManager().getNode(id);
            if (object != null && !(descriptor = this.actingContext.getEntityResolver().getClassDescriptor(id.getEntityName())).isFault(object) && !((related = descriptor.getProperty(relationshipQuery.getRelationshipName()).readPropertyDirectly(object)) instanceof Fault)) {
                List<Object> result;
                if (related == null) {
                    result = new ArrayList(1);
                } else if (related instanceof List) {
                    result = (List)related;
                } else {
                    result = new ArrayList(1);
                    result.add(related);
                }
                this.response = new ListResponse(result);
                return true;
            }
        }
        return false;
    }

    protected void runQuery() {
        this.response = this.actingContext.getChannel().onQuery(this.actingContext, this.query);
    }
}

